/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.tests.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewColumnLabelProvider;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.TaskReview;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.tasks.core.ITask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReviewColumnLabelProviderTest {
    private final String summaryString = "new changes";
    private final String incomingString = "incoming changes";
    ITask mockTask1;
    ITask mockTask2;
    TaskReview myTaskReview1;
    TaskReview myTaskReview2;
    ReviewColumnLabelProvider myLabelProvider;

    @Before
    public void setUp() {
        this.mockTask1 = new TaskTask("mock", "http://mock", "taskID");
        this.mockTask1.setAttribute("CODE_REVIEW", "0");
        this.mockTask1.setAttribute("VERIFIED", "0");
        this.mockTask1.setAttribute("INCOMING_REVIEW", "true");
        this.myTaskReview1 = new TaskReview(this.mockTask1);
        this.mockTask2 = new TaskTask("mock", "http://mock", "taskID");
        this.mockTask2.setSummary("new changes");
        this.mockTask2.setAttribute("CODE_REVIEW", "2");
        this.mockTask2.setAttribute("VERIFIED", "2");
        this.mockTask2.setAttribute("INCOMING_REVIEW", "incoming changes");
        this.myTaskReview2 = new TaskReview(this.mockTask2);
        this.myLabelProvider = new ReviewColumnLabelProvider();
    }

    @Test
    public void imagePresentTest() {
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 1));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 2));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 3));
    }

    @Test
    public void columnTextTests() {
        Assert.assertEquals((Object)"new changes", (Object)this.myTaskReview2.getSummary());
        Assert.assertEquals((Object)"new changes", (Object)this.myLabelProvider.getColumnText((Object)this.myTaskReview2, 0));
        Assert.assertEquals((Object)"incoming changes", (Object)this.myLabelProvider.getColumnText((Object)this.myTaskReview2, 3));
        Assert.assertEquals((Object)"", (Object)this.myLabelProvider.getColumnText((Object)this.myTaskReview2, 1));
        Assert.assertEquals((Object)"", (Object)this.myLabelProvider.getColumnText((Object)this.myTaskReview2, 2));
        Assert.assertEquals((Object)"", (Object)this.myLabelProvider.getColumnText((Object)this.myTaskReview2, 5));
        Assert.assertEquals((Object)"", (Object)this.myLabelProvider.getColumnText((Object)this.myTaskReview2, 4));
    }

    @Test
    public void imageNotPresentTests() {
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 1));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 2));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 3));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
    }

    @Test
    public void noImageTests() {
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 1));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 2));
        Assert.assertNotNull((Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 3));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
        Assert.assertEquals((Object)CommonImages.getImage((ImageDescriptor)CommonImages.OVERLAY_CLEAR), (Object)this.myLabelProvider.getColumnImage((Object)this.myTaskReview1, 0));
    }
}

