/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.tests.ui;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommentContainer;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.tests.util.MockReviewBehavior;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;

public class ReviewAnnotationModelTest
extends TestCase {
    private static final String DEFAULT_TEXT = "This change looks good.";
    private static final long DEFAULT_TIMESTAMP = 1388577600000L;
    private IDocument doc;
    private IReviewItem review;
    private ReviewAnnotationModel model;

    protected void setUp() throws Exception {
        this.doc = new Document("A test document, nothing special.");
        this.review = IReviewsFactory.INSTANCE.createFileItem();
        this.generateComment(DEFAULT_TEXT, new Date(1388577600000L));
        this.model = new ReviewAnnotationModel();
        this.model.setItem(this.review, (ReviewBehavior)new MockReviewBehavior());
        this.model.connect(this.doc);
    }

    protected void tearDown() throws Exception {
        this.model.disconnect(this.doc);
    }

    public void testConnect() {
        Iterator iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)1, (int)this.getCount(iter));
        this.model.disconnect(this.doc);
        iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)0, (int)this.getCount(iter));
        this.model.connect(this.doc);
        iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)1, (int)this.getCount(iter));
    }

    public void testNotifyChanged() {
        Iterator iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)1, (int)this.getCount(iter));
        IComment clone = this.generateComment(DEFAULT_TEXT, new Timestamp(1388577600000L));
        NotificationImpl notification = new NotificationImpl(3, null, (Object)clone);
        this.model.getItem().eNotify((Notification)notification);
        iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)1, (int)this.getCount(iter));
        IComment newComment = this.generateComment("Actually, maybe it needs more work.", new Date());
        notification = new NotificationImpl(3, null, (Object)newComment);
        this.model.getItem().eNotify((Notification)notification);
        iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)2, (int)this.getCount(iter));
        notification = new NotificationImpl(4, (Object)newComment, null);
        this.model.getItem().eNotify((Notification)notification);
        iter = this.model.getAnnotationIterator();
        ReviewAnnotationModelTest.assertEquals((int)1, (int)this.getCount(iter));
    }

    private int getCount(Iterator<Annotation> iter) {
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }

    private IUser generateUser() {
        IUser user = IReviewsFactory.INSTANCE.createUser();
        user.setId("1");
        user.setDisplayName("Leo Dos Santos");
        user.setEmail("leo@testkop.com");
        return user;
    }

    private IComment generateComment(String text, Date date) {
        IComment comment = IReviewsFactory.INSTANCE.createComment();
        comment.getLocations().add(this.generateLocation());
        comment.setDescription(text);
        comment.setCreationDate(date);
        comment.setDraft(false);
        comment.setId("12345");
        comment.setAuthor(this.generateUser());
        comment.setItem((ICommentContainer)this.review);
        return comment;
    }

    private ILocation generateLocation() {
        ILineRange range = IReviewsFactory.INSTANCE.createLineRange();
        range.setStart(0);
        range.setEnd(10);
        ILineLocation location = IReviewsFactory.INSTANCE.createLineLocation();
        location.getRanges().add(range);
        return location;
    }
}

