/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.spi.edit.remote;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractDataLocator;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteService;
import org.eclipse.mylyn.reviews.core.spi.remote.JobRemoteService;
import org.eclipse.mylyn.reviews.spi.edit.remote.AbstractRemoteEditFactoryProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractRemoteEditFactoryProviderTest
extends TestCase {
    AbstractDataLocator testDataLocator = new AbstractDataLocator(){

        protected IPath getSystemDataPath() {
            return new Path(FileUtils.getTempDirectory().getAbsolutePath());
        }

        protected IPath getLocatorDataSegment() {
            return new Path("org.eclipse.mylyn.reviews.tests").append("RemoteEditFactoryTest");
        }
    };

    @Before
    protected void setUp() throws Exception {
        File rootDir = new File(this.testDataLocator.getModelPath().removeLastSegments(1).toPortableString());
        FileUtils.deleteDirectory((File)rootDir);
    }

    @Test
    public void testCreateRoot() {
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(this.testDataLocator);
        String filePath = this.testDataLocator.getModelPath() + File.separator + "Container" + File.separator + "EPackage" + File.separator + "EPackage.ecore";
        File file = new File(filePath);
        Assert.assertThat((String)("File should not exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)false));
        provider.open();
        Assert.assertThat((Object)((EPackage)provider.getRoot()), (Matcher)Matchers.instanceOf(EPackage.class));
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        ((EPackage)provider.getRoot()).setNsPrefix("RootPackage");
        Assert.assertThat((Object)((EPackage)provider.getRoot()), (Matcher)Matchers.instanceOf(EPackage.class));
        Assert.assertThat((Object)provider.getEditingDomain().getResourceSet().getResources().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((Resource)provider.getEditingDomain().getResourceSet().getResources().get(0)).getContents().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((EObject)((Resource)provider.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0)), (Matcher)Matchers.is((Object)provider.getRoot()));
        provider.close();
        Assert.assertThat((Object)((EPackage)provider.getRoot()), (Matcher)Matchers.nullValue());
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        provider.open();
        Assert.assertThat((Object)((EPackage)provider.getRoot()), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getNsPrefix(), (Matcher)Matchers.is((Object)"RootPackage"));
    }

    @Test
    public void testBadFile() throws Exception {
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(this.testDataLocator);
        String filePath = this.testDataLocator.getModelPath() + File.separator + "Container" + File.separator + "EPackage" + File.separator + "EPackage.ecore";
        File parentDir = new File(this.testDataLocator.getModelPath() + File.separator + "Container" + File.separator + "EPackage");
        parentDir.mkdirs();
        File file = new File(filePath);
        file.createNewFile();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("Garbage");
        bufferedWriter.close();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.is((Object)"Garbage"));
        reader.close();
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        provider.open();
        Assert.assertThat((Object)((EPackage)provider.getRoot()), (Matcher)Matchers.instanceOf(EPackage.class));
        provider.save();
        reader = new BufferedReader(new FileReader(file));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.startsWith((String)"<?xml version"));
        reader.close();
    }

    @Test
    public void testBadContents() throws Exception {
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(this.testDataLocator);
        provider.open();
        Resource resource = (Resource)provider.getEditingDomain().getResourceSet().getResources().get(0);
        EList contents = resource.getContents();
        contents.clear();
        EClass createEClass = EcoreFactory.eINSTANCE.createEClass();
        contents.add((Object)createEClass);
        provider.close();
        provider.open();
    }

    @Test
    public void testCreateChild() {
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(this.testDataLocator);
        provider.setService((AbstractRemoteService)new JobRemoteService());
        String filePath = this.testDataLocator.getModelPath() + File.separator + "Container" + File.separator + "EClass" + File.separator + "123.ecore";
        File file = new File(filePath);
        Assert.assertThat((String)("File should not exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)false));
        provider.open();
        EClass child = (EClass)provider.open("123");
        Assert.assertThat((Object)child.getName(), (Matcher)Matchers.is((Object)"123"));
        Assert.assertThat((Object)child.getInstanceClassName(), (Matcher)Matchers.nullValue());
        child.setInstanceClassName("Foo");
        Assert.assertThat((Object)((EClassifier)((EPackage)provider.getRoot()).getEClassifiers().get(0)), (Matcher)Matchers.sameInstance((Object)child));
        provider.close((EObject)child);
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getEClassifiers().size(), (Matcher)Matchers.is((Object)0));
        provider.close();
        provider.open();
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getEClassifiers().size(), (Matcher)Matchers.is((Object)0));
        EClass newChild = (EClass)provider.open("123");
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getEClassifiers().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)newChild.getName(), (Matcher)Matchers.is((Object)"123"));
        Assert.assertThat((Object)newChild.getInstanceClassName(), (Matcher)Matchers.is((Object)"Foo"));
    }

    @Test
    public void testBadChild() throws Exception {
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(this.testDataLocator);
        provider.setService((AbstractRemoteService)new JobRemoteService());
        String filePath = this.testDataLocator.getModelPath() + File.separator + "Container" + File.separator + "EClass" + File.separator + "123.ecore";
        File file = new File(filePath);
        Assert.assertThat((String)("File should not exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)false));
        provider.open();
        EClass child = (EClass)provider.open("123");
        Assert.assertThat((Object)child.getName(), (Matcher)Matchers.is((Object)"123"));
        child.setInstanceClassName("Foo");
        provider.close((EObject)child);
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getEClassifiers().size(), (Matcher)Matchers.is((Object)0));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("Garbage");
        bufferedWriter.close();
        EClass newChild = (EClass)provider.open("123");
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getEClassifiers().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)newChild.getInstanceClassName(), (Matcher)Matchers.nullValue());
        provider.save((EObject)newChild);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Assert.assertThat((Object)reader.readLine(), (Matcher)Matchers.startsWith((String)"<?xml version"));
        reader.close();
    }

    @Test
    public void testSpaces() throws IOException {
        AbstractDataLocator testSpaceDataLocator = new AbstractDataLocator(){

            protected IPath getSystemDataPath() {
                return new Path(FileUtils.getTempDirectory().getAbsolutePath());
            }

            protected IPath getLocatorDataSegment() {
                return new Path("org.eclipse.mylyn.reviews.tests").append("RemoteEditFactoryTest Spaces");
            }
        };
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(testSpaceDataLocator);
        provider.setService((AbstractRemoteService)new JobRemoteService());
        String osString = testSpaceDataLocator.getModelPath().toOSString();
        Assert.assertThat((Object)osString.endsWith("RemoteEditFactoryTest Spaces"), (Matcher)Matchers.is((Object)true));
        String spacesOsString = StringUtils.replace((String)osString, (String)" ", (String)"%20");
        Assert.assertThat((Object)spacesOsString.endsWith("RemoteEditFactoryTest%20Spaces"), (Matcher)Matchers.is((Object)true));
        String filePath = String.valueOf(osString) + File.separator + "Container" + File.separator + "EClass" + File.separator + "123.ecore";
        File file = new File(filePath);
        File badDir = new File(spacesOsString);
        Assert.assertThat((String)("File should not exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((String)("Directory should not exist at: " + badDir.getAbsolutePath()), (Object)badDir.exists(), (Matcher)Matchers.is((Object)false));
        provider.open();
        EClass child = (EClass)provider.open("123");
        Assert.assertThat((Object)child.getName(), (Matcher)Matchers.is((Object)"123"));
        Assert.assertThat((Object)child.getInstanceClassName(), (Matcher)Matchers.nullValue());
        child.setInstanceClassName("Foo");
        Assert.assertThat((Object)((EClassifier)((EPackage)provider.getRoot()).getEClassifiers().get(0)), (Matcher)Matchers.sameInstance((Object)child));
        provider.close((EObject)child);
        Assert.assertThat((String)("File should exist at: " + filePath), (Object)file.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((EPackage)provider.getRoot()).getEClassifiers().size(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)("File should not exist at: " + badDir.getAbsolutePath()), (Object)badDir.exists(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDeleteCache() throws Exception {
        TestEditFactoryProvider provider = new TestEditFactoryProvider();
        provider.setDataLocator(this.testDataLocator);
        File testFile = new File(this.testDataLocator.getModelPath() + File.separator + "Blah");
        testFile.mkdirs();
        File root = new File(this.testDataLocator.getModelPath().toOSString());
        Assert.assertThat((Object)root.exists(), (Matcher)Matchers.is((Object)true));
        provider.deleteCache();
        Assert.assertThat((Object)root.exists(), (Matcher)Matchers.is((Object)false));
    }

    class TestEditFactoryProvider
    extends AbstractRemoteEditFactoryProvider<EPackage, EClass> {
        public TestEditFactoryProvider() {
            super((EFactory)EcoreFactory.eINSTANCE, EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, EcorePackage.Literals.ENAMED_ELEMENT__NAME, EcorePackage.Literals.ECLASS);
        }

        public String getFileExtension(EClass eClass) {
            return "ecore";
        }

        public String getContainerSegment() {
            return "Container";
        }

        public EditingDomain getEditingDomain() {
            return super.getEditingDomain();
        }
    }
}

