/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.reviews.internal.core.TaskReviewsMappingsStore;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TaskReviewMappingStoreTest {
    final String taskUrl1 = "https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635";
    final String taskUrl2 = "https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343";
    final String notATaskUrl = "www.hello.com";
    ITask task1;
    ITask task2;
    final String reviewUrl1 = "https://git.eclipse.org/r/#/c/56269/";
    final String reviewUrl2 = "https://git.eclipse.org/r/#/c/43534/";
    final String reviewUrlNoTask = "https://git.eclipse.org/r/#/c/12333/";
    final String descriptionWithTaskUrl1 = "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>";
    final String descriptionWithTaskUrl2 = "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>";
    final String descriptionWithReviewAndTaskUrl = "477635: [UCOSP] contribute reviews section to task editor showing associated reviews https://git.eclipse.org/r/#/c/43534/ Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>";
    final String descriptionWithNoTaskUrl = "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed  Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>";
    final String descriptionWithNotATaskUrl = "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed www.hello.com Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>";
    ITask review1;
    ITask review2;
    ITask reviewNoTask;
    private TaskDataManager taskDataManager;

    @Before
    public void setup() {
        this.review1 = new TaskTask("reviewKind", "https://git.eclipse.org/r/#/c/56269/", "3");
        this.review1.setUrl("https://git.eclipse.org/r/#/c/56269/");
        this.review2 = new TaskTask("reviewKind", "https://git.eclipse.org/r/#/c/43534/", "4");
        this.review2.setUrl("https://git.eclipse.org/r/#/c/43534/");
        this.reviewNoTask = new TaskTask("reviewKind", "https://git.eclipse.org/r/#/c/12333/", "5");
        this.reviewNoTask.setUrl("https://git.eclipse.org/r/#/c/12333/");
        this.task1 = new TaskTask("taskKind", "https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635", "1");
        this.task1.setUrl("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635");
        this.task2 = new TaskTask("taskKind", "https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343", "2");
        this.task2.setUrl("https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343");
    }

    public TaskReviewsMappingsStore getEmptyTaskReviewStore() {
        TaskRepositoryManager repositoryManager = (TaskRepositoryManager)Mockito.mock(TaskRepositoryManager.class);
        ReviewsConnector reviewConnector = (ReviewsConnector)Mockito.mock(ReviewsConnector.class);
        AbstractRepositoryConnector taskConnector = (AbstractRepositoryConnector)Mockito.mock(AbstractRepositoryConnector.class);
        this.taskDataManager = (TaskDataManager)Mockito.mock(TaskDataManager.class);
        Mockito.when((Object)repositoryManager.getConnectorForRepositoryTaskUrl(ArgumentMatchers.anyString())).thenReturn((Object)reviewConnector);
        Mockito.when((Object)repositoryManager.getRepositoryConnector("reviewKind")).thenReturn((Object)reviewConnector);
        Mockito.when((Object)repositoryManager.getRepositoryConnector("taskKind")).thenReturn((Object)taskConnector);
        MockTaskReviewsMappingsStore taskReviewsMappingStore = new MockTaskReviewsMappingsStore((TaskList)Mockito.mock(TaskList.class), repositoryManager);
        return taskReviewsMappingStore;
    }

    public TaskData addReviewData(ITask review, String description) throws CoreException {
        TaskData reviewData = new TaskData(new TaskAttributeMapper(new TaskRepository("", "")), "", review.getUrl(), review.getTaskId());
        reviewData.getRoot().createMappedAttribute("task.common.description").setValue(description);
        Mockito.when((Object)this.taskDataManager.getTaskData(review)).thenReturn((Object)reviewData);
        return reviewData;
    }

    @Test
    public void testAdd() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getTaskUrl(this.review1).equals("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635"));
    }

    @Test
    public void testAddTwice() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Collection reviewUrls = taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635");
        Assert.assertTrue((boolean)reviewUrls.contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((reviewUrls.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)taskReviewsMappingStore.getTaskUrl(this.review1).equals("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635"));
    }

    @Test
    public void testAddMultiple() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskData reviewData2 = this.addReviewData(this.review2, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta1 = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        TaskContainerDelta delta2 = new TaskContainerDelta((IRepositoryElement)this.review2, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.addTaskAssocation(this.review2, reviewData2);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta1, (Object)delta2));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getTaskUrl(this.review1).equals("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343").contains("https://git.eclipse.org/r/#/c/43534/"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getTaskUrl(this.review2).equals("https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343"));
    }

    @Test
    public void testReviewNotLinkedToReview() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews https://git.eclipse.org/r/#/c/43534/ Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertFalse((boolean)taskReviewsMappingStore.getReviewUrls("https://git.eclipse.org/r/#/c/43534/").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getTaskUrl(this.review1).equals("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635"));
    }

    @Test
    public void testRemove() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.DELETED);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertFalse((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((taskReviewsMappingStore.getTaskUrl(this.review1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.CONTENT);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertFalse((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertEquals((Object)"https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343", (Object)taskReviewsMappingStore.getTaskUrl(this.review1));
    }

    @Test
    public void testUpdateNoTask() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed Task-Url: https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635 Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertTrue((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed  Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.CONTENT);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertFalse((boolean)taskReviewsMappingStore.getReviewUrls("https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635").contains("https://git.eclipse.org/r/#/c/56269/"));
        Assert.assertTrue((taskReviewsMappingStore.getTaskUrl(this.review1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddNoTask() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed  Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertTrue((taskReviewsMappingStore.getTaskUrl(this.review1) == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddANonTaskUrl() throws CoreException {
        TaskReviewsMappingsStore taskReviewsMappingStore = this.getEmptyTaskReviewStore();
        TaskData reviewData1 = this.addReviewData(this.review1, "477635: [UCOSP] contribute reviews section to task editor showing associated reviews Change-Id: I3a38d375688aad7be36bfd58c3311d692eb51ed www.hello.com Signed-off-by: Blaine Lewis <Blaine1@ualberta.ca>");
        TaskContainerDelta delta = new TaskContainerDelta((IRepositoryElement)this.review1, TaskContainerDelta.Kind.ADDED);
        taskReviewsMappingStore.addTaskAssocation(this.review1, reviewData1);
        taskReviewsMappingStore.containersChanged((Set)ImmutableSet.of((Object)delta));
        Assert.assertTrue((taskReviewsMappingStore.getTaskUrl(this.review1) == null ? 1 : 0) != 0);
    }

    class MockTaskReviewsMappingsStore
    extends TaskReviewsMappingsStore {
        public MockTaskReviewsMappingsStore(TaskList taskList, TaskRepositoryManager repositoryManager) {
            super(taskList, repositoryManager);
        }

        ITask getTaskByUrl(String url) {
            switch (url) {
                case "https://bugs.eclipse.org/bugs/show_bug.cgi?id=477635": {
                    return TaskReviewMappingStoreTest.this.task1;
                }
                case "https://bugs.eclipse.org/bugs/show_bug.cgi?id=345343": {
                    return TaskReviewMappingStoreTest.this.task2;
                }
                case "https://git.eclipse.org/r/#/c/56269/": {
                    return TaskReviewMappingStoreTest.this.review1;
                }
                case "https://git.eclipse.org/r/#/c/43534/": {
                    return TaskReviewMappingStoreTest.this.review2;
                }
            }
            return null;
        }
    }
}

