/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import java.util.ArrayList;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;
import org.eclipse.mylyn.reviews.internal.core.TaskBuildStatusMapper;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Test;

public class TaskBuildStatusMapperTest {
    @Test
    public void attributeValueDependsOnChildren() {
        TaskAttribute attribute1 = this.createBuildAttribute("https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-tasks/1066/");
        TaskAttribute attribute2 = this.createBuildAttribute("https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-tasks/1067/");
        Assert.assertFalse((boolean)attribute1.getValue().equals(attribute2.getValue()));
    }

    private TaskAttribute createBuildAttribute(String url) {
        ArrayList<BuildResult> results = new ArrayList<BuildResult>();
        String JOB_NAME = "SameJob";
        results.add(new BuildResult(0, url, BuildResult.BuildStatus.STARTED, 1, "SameJob"));
        TaskBuildStatusMapper mapper = new TaskBuildStatusMapper(results);
        TaskAttribute root = this.createRootAttribute();
        mapper.applyTo(root);
        return root;
    }

    @Test
    public void emptyCollectionReturnsRootWithNoChildren() {
        ArrayList results = new ArrayList();
        TaskBuildStatusMapper mapper = new TaskBuildStatusMapper(results);
        TaskAttribute root = this.createRootAttribute();
        mapper.applyTo(root);
        Assert.assertEquals((long)0L, (long)root.getAttributes().size());
    }

    @Test
    public void collectionWithSameJobNameShouldTakeHighestJobNumber() throws Exception {
        ArrayList<BuildResult> results = new ArrayList<BuildResult>();
        String HUDSON_BUILD_URL = "https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-tasks/1066/";
        String JOB_NAME = "SameJob";
        results.add(new BuildResult(0, "https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-tasks/1066/", BuildResult.BuildStatus.STARTED, 1, "SameJob"));
        results.add(new BuildResult(1, "https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-tasks/1066/", BuildResult.BuildStatus.STARTED, 1, "SameJob"));
        TaskBuildStatusMapper mapper = new TaskBuildStatusMapper(results);
        TaskAttribute root = this.createRootAttribute();
        mapper.applyTo(root);
        Assert.assertEquals((long)1L, (long)root.getAttributes().size());
        Assert.assertNotNull((Object)root.getAttribute("BUILD_RESULT-0"));
        TaskAttribute taskAttribute = root.getAttribute("BUILD_RESULT-0");
        int buildNumber = Integer.parseInt(taskAttribute.getAttribute("NUMBER").getValue());
        Assert.assertEquals((long)1L, (long)buildNumber);
        Assert.assertEquals((Object)"SameJob", (Object)taskAttribute.getAttribute("JOB").getValue());
        Assert.assertEquals((Object)"https://hudson.eclipse.org/mylyn/job/gerrit-mylyn-tasks/1066/", (Object)taskAttribute.getAttribute("URL").getValue());
    }

    @Test
    public void collectionWithDifferentJobNamesProducesUnqiueEntries() {
        ArrayList<BuildResult> results = new ArrayList<BuildResult>();
        String buildUrl = "http://hudson.someurl.com/";
        results.add(new BuildResult(0, buildUrl, BuildResult.BuildStatus.STARTED, 1, "SameJob"));
        String buildUrl2 = "http://hudson.someurl.com/alpha";
        results.add(new BuildResult(1, buildUrl2, BuildResult.BuildStatus.STARTED, 1, "DifferentJob"));
        TaskBuildStatusMapper mapper = new TaskBuildStatusMapper(results);
        TaskAttribute root = this.createRootAttribute();
        mapper.applyTo(root);
        Assert.assertEquals((long)2L, (long)root.getAttributes().size());
        TaskAttribute firstBuildResultAttribute = root.getAttribute("BUILD_RESULT-0");
        Assert.assertNotNull((Object)firstBuildResultAttribute);
        Assert.assertEquals((Object)"0", (Object)firstBuildResultAttribute.getAttribute("NUMBER").getValue());
        Assert.assertEquals((Object)"SameJob", (Object)firstBuildResultAttribute.getAttribute("JOB").getValue());
        Assert.assertEquals((Object)buildUrl, (Object)firstBuildResultAttribute.getAttribute("URL").getValue());
        Assert.assertEquals((Object)BuildResult.BuildStatus.STARTED.toString(), (Object)firstBuildResultAttribute.getAttribute("STATUS").getValue());
        TaskAttribute secondBuildResultAttribute = root.getAttribute("BUILD_RESULT-1");
        Assert.assertNotNull((Object)secondBuildResultAttribute);
        Assert.assertEquals((Object)"1", (Object)secondBuildResultAttribute.getAttribute("NUMBER").getValue());
        Assert.assertEquals((Object)"DifferentJob", (Object)secondBuildResultAttribute.getAttribute("JOB").getValue());
        Assert.assertEquals((Object)buildUrl2, (Object)secondBuildResultAttribute.getAttribute("URL").getValue());
        Assert.assertEquals((Object)BuildResult.BuildStatus.STARTED.toString(), (Object)secondBuildResultAttribute.getAttribute("STATUS").getValue());
    }

    private TaskAttribute createRootAttribute() {
        TaskAttributeMapper mapper = new TaskAttributeMapper(new TaskRepository("", ""));
        TaskData mockTestData = new TaskData(mapper, "", "", "");
        return mockTestData.getRoot();
    }
}

