/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.internal.core.ReviewFileCommentsMapper;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReviewFileCommentsMapperTest {
    private TaskData taskData;
    private IReview review;
    private ReviewFileCommentsMapper mapper;

    @Before
    public void setup() {
        TaskRepository repository = new TaskRepository("kind", "url");
        TaskAttributeMapper attributeMapper = new TaskAttributeMapper(repository);
        this.taskData = new TaskData(attributeMapper, "kind", "url", "id");
        this.review = (IReview)Mockito.mock(IReview.class);
        this.mapper = new ReviewFileCommentsMapper(this.review);
    }

    @Test
    public void emptyReview() {
        ((IReview)Mockito.doReturn((Object)ImmutableList.of()).when((Object)this.review)).getSets();
        this.mapper.applyTo(this.taskData);
        TaskAttribute comments = this.taskData.getRoot().getAttribute("FILE-COMMENTS");
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)comments.getAttributes());
    }

    @Test
    public void reviewWithoutComments() {
        IReviewItemSet set = (IReviewItemSet)Mockito.mock(IReviewItemSet.class);
        IFileItem file = (IFileItem)Mockito.mock(IFileItem.class);
        ((IReview)Mockito.doReturn((Object)ImmutableList.of((Object)set)).when((Object)this.review)).getSets();
        ((IReviewItemSet)Mockito.doReturn((Object)ImmutableList.of((Object)file)).when((Object)set)).getItems();
        ((IFileItem)Mockito.doReturn((Object)ImmutableList.of()).when((Object)file)).getAllComments();
        this.mapper.applyTo(this.taskData);
        TaskAttribute comments = this.taskData.getRoot().getAttribute("FILE-COMMENTS");
        Assert.assertNotNull((Object)comments);
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)comments.getAttributes());
    }

    @Test
    public void reviewWithComments() {
        IReviewItemSet set1 = (IReviewItemSet)Mockito.mock(IReviewItemSet.class);
        IReviewItemSet set2 = (IReviewItemSet)Mockito.mock(IReviewItemSet.class);
        IFileItem file1 = (IFileItem)Mockito.mock(IFileItem.class);
        IFileItem file2 = (IFileItem)Mockito.mock(IFileItem.class);
        IFileItem file3 = (IFileItem)Mockito.mock(IFileItem.class);
        IComment comment1 = (IComment)Mockito.mock(IComment.class);
        IComment comment2 = (IComment)Mockito.mock(IComment.class);
        IComment comment3 = (IComment)Mockito.mock(IComment.class);
        ((IReview)Mockito.doReturn((Object)ImmutableList.of((Object)set1, (Object)set2)).when((Object)this.review)).getSets();
        ((IReviewItemSet)Mockito.doReturn((Object)ImmutableList.of((Object)file1)).when((Object)set1)).getItems();
        ((IReviewItemSet)Mockito.doReturn((Object)ImmutableList.of((Object)file2, (Object)file3)).when((Object)set2)).getItems();
        ((IFileItem)Mockito.doReturn((Object)ImmutableList.of((Object)comment1)).when((Object)file1)).getAllComments();
        ((IFileItem)Mockito.doReturn((Object)ImmutableList.of()).when((Object)file2)).getAllComments();
        ((IFileItem)Mockito.doReturn((Object)ImmutableList.of((Object)comment2, (Object)comment3)).when((Object)file2)).getAllComments();
        ((IComment)Mockito.doReturn((Object)"id1").when((Object)comment1)).getId();
        ((IComment)Mockito.doReturn((Object)"id2").when((Object)comment2)).getId();
        ((IComment)Mockito.doReturn((Object)"id3").when((Object)comment3)).getId();
        ((IComment)Mockito.doReturn((Object)"comment 1").when((Object)comment1)).getDescription();
        ((IComment)Mockito.doReturn((Object)"comment 2").when((Object)comment2)).getDescription();
        ((IComment)Mockito.doReturn((Object)"comment 3").when((Object)comment3)).getDescription();
        this.mapper.applyTo(this.taskData);
        TaskAttribute comments = this.taskData.getRoot().getAttribute("FILE-COMMENTS");
        Assert.assertNotNull((Object)comments);
        this.assertComments((ImmutableMap<String, String>)ImmutableMap.of((Object)"id1", (Object)"comment 1", (Object)"id2", (Object)"comment 2", (Object)"id3", (Object)"comment 3"), comments);
    }

    private void assertComments(ImmutableMap<String, String> children, TaskAttribute attribute) {
        for (String attributeId : children.keySet()) {
            Assert.assertNotNull((Object)attribute.getAttribute(attributeId));
            Assert.assertEquals((Object)children.get((Object)attributeId), (Object)attribute.getAttribute(attributeId).getValue());
        }
    }
}

