/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

final class TestRemoteEmfObserver<P extends EObject, T, L, C>
extends RemoteEmfObserver<P, T, L, C> {
    static final int TEST_TIMEOUT = 100;
    boolean currentlyUpdating;
    int updated;
    int updating;
    int updatedMember;
    int responded;

    public TestRemoteEmfObserver() {
    }

    public TestRemoteEmfObserver(RemoteEmfConsumer<P, T, L, ?, ?, C> consumer) {
        super(consumer);
    }

    public synchronized void updating() {
        ++this.updating;
        this.currentlyUpdating = true;
    }

    public void updated(boolean modified) {
        ++this.responded;
        if (modified) {
            ++this.updated;
        }
        if (this.consumer.getModelObject() instanceof Collection) {
            ++this.updatedMember;
        }
        this.currentlyUpdating = false;
    }

    protected void waitForResponse(int response, int update) {
        long delay = 0L;
        while (delay < 100L) {
            if (this.responded >= response) break;
            try {
                Thread.sleep(10L);
                delay += 10L;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertThat((String)("Wrong # responses: " + this.responded + ", updated: " + this.updated), (Object)this.responded, (Matcher)Matchers.is((Object)response));
        Assert.assertThat((String)("Wrong # updates" + this.updated), (Object)this.updated, (Matcher)Matchers.is((Object)update));
    }
}

