/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteEClass;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteFactoryProvider;

class TestEClassRemoteFactory
extends AbstractRemoteEmfFactory<EPackage, EClass, String, TestRemoteEClass, String, Integer> {
    static TestRemoteEClass remote1 = new TestRemoteEClass("Remote Object 1");
    static TestRemoteEClass remote2 = new TestRemoteEClass("Remote Object 2");
    static Map<String, TestRemoteEClass> remoteForKey = new HashMap<String, TestRemoteEClass>();

    public TestEClassRemoteFactory() {
        super(new TestRemoteFactoryProvider(), EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME);
        remoteForKey.put("remoteKeyFor Object 1", remote1);
        remoteForKey.put("remoteKeyFor Object 2", remote2);
    }

    public TestRemoteEClass pull(EPackage parent, String remoteKey, IProgressMonitor monitor) throws CoreException {
        return remoteForKey.get(remoteKey);
    }

    protected EClass createModel(EPackage parent, TestRemoteEClass remoteObject) {
        EClass clazz = EcoreFactory.eINSTANCE.createEClass();
        clazz.setName(remoteObject.name.replaceAll("Remote", "Local"));
        return clazz;
    }

    public boolean updateModel(EPackage parent, EClass object, TestRemoteEClass remoteObject) {
        if (remoteObject != null) {
            object.setInstanceTypeName(remoteObject.data);
        }
        return true;
    }

    public String getRemoteKey(TestRemoteEClass remoteObject) {
        if (remoteObject == remote1) {
            return "remoteKeyFor Object 1";
        }
        if (remoteObject == remote2) {
            return "remoteKeyFor Object 2";
        }
        throw new RuntimeException();
    }

    public String getLocalKeyForRemoteKey(String remoteKey) {
        return remoteKey.replace("remote", "local");
    }
}

