/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractRemoteConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.JobRemoteService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RemoteServiceTest {
    Thread testThread;

    @Test
    public void testExecute() throws CoreException {
        JobRemoteService remoteService = new JobRemoteService();
        Consumer consumer = new Consumer();
        remoteService.retrieve((AbstractRemoteConsumer)consumer, false);
        consumer.waitForDone();
        Assert.assertThat((Object)consumer.status.getSeverity(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)consumer.retrieve, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)consumer.apply, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testExecuteSync() throws CoreException {
        JobRemoteService remoteService = new JobRemoteService();
        Consumer consumer = new Consumer();
        consumer.async = false;
        remoteService.retrieve((AbstractRemoteConsumer)consumer, false);
        consumer.waitForDone();
        Assert.assertThat((Object)consumer.status.getSeverity(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)consumer.retrieve, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)consumer.apply, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testExecuteCoreException() throws CoreException {
        JobRemoteService remoteService = new JobRemoteService();
        BrokenConsumer consumer = new BrokenConsumer();
        remoteService.retrieve((AbstractRemoteConsumer)consumer, false);
        consumer.waitForDone();
        Assert.assertThat((Object)consumer.status.getSeverity(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)consumer.retrieve, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)consumer.apply, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExecuteCoreExceptionSync() throws CoreException {
        JobRemoteService remoteService = new JobRemoteService();
        BrokenConsumer consumer = new BrokenConsumer();
        consumer.async = false;
        remoteService.retrieve((AbstractRemoteConsumer)consumer, false);
        consumer.waitForDone();
        Assert.assertThat((Object)consumer.status.getSeverity(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)consumer.retrieve, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)consumer.apply, (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testExecuteModelThread() throws CoreException {
        ThreadedService remoteService = new ThreadedService();
        ModelThreadConsumer consumer = new ModelThreadConsumer();
        remoteService.retrieve(consumer, false);
        consumer.waitForDone();
        Assert.assertThat((Object)consumer.modelThread.getName(), (Matcher)Matchers.is((Object)"Test Thread"));
        Assert.assertThat((Object)consumer.retrieveThread.getName(), (Matcher)Matchers.not((Object)"Test Thread"));
        Assert.assertThat((Object)consumer.status.getSeverity(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)consumer.retrieve, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)consumer.apply, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)consumer.retrieveThread, (Matcher)Matchers.not((Object)Thread.currentThread()));
    }

    @Test
    public void testExecuteModelThreadSync() throws CoreException {
        ThreadedService remoteService = new ThreadedService();
        ModelThreadConsumer consumer = new ModelThreadConsumer();
        consumer.async = false;
        remoteService.retrieve(consumer, false);
        consumer.waitForDone();
        Assert.assertThat((Object)consumer.modelThread.getName(), (Matcher)Matchers.is((Object)"Test Thread"));
        Assert.assertThat((Object)consumer.retrieveThread.getName(), (Matcher)Matchers.not((Object)"Test Thread"));
        Assert.assertThat((Object)consumer.status.getSeverity(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)consumer.retrieve, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)consumer.apply, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)consumer.retrieveThread, (Matcher)Matchers.is((Object)Thread.currentThread()));
    }

    class BrokenConsumer
    extends Consumer {
        BrokenConsumer() {
        }

        @Override
        public void pull(boolean force, IProgressMonitor monitor) throws CoreException {
            throw new CoreException((IStatus)new Status(4, "blah", "Whoops!"));
        }
    }

    class Consumer
    extends AbstractRemoteConsumer {
        boolean retrieve;
        boolean apply;
        boolean notify;
        boolean async = true;
        IStatus status;

        Consumer() {
        }

        public void pull(boolean force, IProgressMonitor monitor) throws CoreException {
            this.retrieve = true;
        }

        public void applyModel(boolean force) {
            this.apply = true;
        }

        public void notifyDone(IStatus status) {
            this.status = status;
        }

        public boolean isAsynchronous() {
            return this.async;
        }

        public String getDescription() {
            return "";
        }

        protected void waitForDone() {
            long delay = 0L;
            while (delay < 100L) {
                if (this.status != null) break;
                try {
                    Thread.sleep(10L);
                    delay += 10L;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Assert.assertThat((Object)this.status, (Matcher)Matchers.notNullValue());
        }

        public boolean isUserJob() {
            return false;
        }

        public boolean isSystemJob() {
            return false;
        }
    }

    class ModelThreadConsumer
    extends Consumer {
        Thread modelThread;
        Thread retrieveThread;

        ModelThreadConsumer() {
        }

        @Override
        public void pull(boolean force, IProgressMonitor monitor) throws CoreException {
            this.retrieveThread = Thread.currentThread();
            super.pull(force, monitor);
        }

        @Override
        public void applyModel(boolean force) {
            this.modelThread = Thread.currentThread();
            super.applyModel(force);
        }
    }

    class ThreadedService
    extends JobRemoteService {
        ThreadedService() {
        }

        public void modelExec(Runnable runnable, boolean block) {
            RemoteServiceTest.this.testThread = new Thread(runnable, "Test Thread");
            RemoteServiceTest.this.testThread.start();
        }
    }
}

