/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestEClassRemoteFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteEClass;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteEmfObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoteEmfObserverTest {
    RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> consumer1;
    RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> consumer2;
    TestRemoteEmfObserver<EPackage, EClass, String, Integer> listener1;
    TestRemoteEmfObserver<EPackage, EClass, String, Integer> listener2;

    @Before
    public void setup() {
        TestEClassRemoteFactory factory = new TestEClassRemoteFactory();
        EPackage parent = EcoreFactory.eINSTANCE.createEPackage();
        this.consumer1 = factory.getConsumerForRemoteKey((EObject)parent, "remoteKeyFor Object 1");
        this.consumer2 = factory.getConsumerForRemoteKey((EObject)parent, "remoteKeyFor Object 2");
        Assert.assertThat(this.consumer1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance(this.consumer2)));
        this.listener1 = new TestRemoteEmfObserver<EPackage, EClass, String, Integer>(this.consumer1);
        this.listener2 = new TestRemoteEmfObserver();
    }

    @Test
    public void testListener2NotUpdated() {
        this.consumer1.retrieve(false);
        this.listener1.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener2.responded, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)this.listener2.updated, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testListener2SetConsumer1() {
        this.listener2.setConsumer(this.consumer1);
        this.consumer1.retrieve(false);
        this.listener1.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener2.responded, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.listener2.updated, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testConsumer1RemoveObserver1() {
        this.listener2.setConsumer(this.consumer1);
        this.consumer1.removeObserver(this.listener1);
        Assert.assertThat((Object)this.listener1.getConsumer(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)(this.listener2.getConsumer() == this.consumer1 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        this.consumer1.retrieve(false);
        this.listener2.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testConsumer2AddObserver1() {
        this.listener2.setConsumer(this.consumer1);
        this.consumer2.addObserver(this.listener1);
        Assert.assertThat((Object)(this.listener1.getConsumer() == this.consumer2 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)(this.listener2.getConsumer() == this.consumer1 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        this.consumer1.retrieve(false);
        this.listener2.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)0));
        this.consumer2.retrieve(false);
        this.listener1.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testListener2SetConsumer2() {
        this.consumer2.addObserver(this.listener1);
        this.listener2.setConsumer(this.consumer2);
        Assert.assertThat((Object)(this.listener1.getConsumer() == this.consumer2 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)(this.listener2.getConsumer() == this.consumer2 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        this.consumer2.retrieve(false);
        this.listener2.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testAddRemoteAndSetListeners() {
        this.consumer1.retrieve(false);
        this.listener1.waitForResponse(1, 1);
        Assert.assertThat((Object)this.listener2.responded, (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)this.listener2.updated, (Matcher)Matchers.is((Object)0));
        this.listener2.setConsumer(this.consumer1);
        this.consumer1.retrieve(false);
        this.listener1.waitForResponse(2, 2);
        Assert.assertThat((Object)this.listener2.responded, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)this.listener2.updated, (Matcher)Matchers.is((Object)1));
        this.consumer1.removeObserver(this.listener1);
        Assert.assertThat((Object)this.listener1.getConsumer(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)(this.listener2.getConsumer() == this.consumer1 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        this.consumer1.retrieve(false);
        this.listener2.waitForResponse(2, 2);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)2));
        this.consumer2.addObserver(this.listener1);
        Assert.assertThat((Object)(this.listener1.getConsumer() == this.consumer2 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)(this.listener2.getConsumer() == this.consumer1 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        this.consumer1.retrieve(false);
        this.listener2.waitForResponse(3, 3);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)2));
        this.consumer2.retrieve(false);
        this.listener1.waitForResponse(3, 3);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)3));
        this.listener2.setConsumer(this.consumer2);
        Assert.assertThat((Object)(this.listener1.getConsumer() == this.consumer2 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)(this.listener2.getConsumer() == this.consumer2 ? 1 : 0), (Matcher)Matchers.is((Object)true));
        this.consumer2.retrieve(false);
        this.listener2.waitForResponse(4, 4);
        Assert.assertThat((Object)this.listener1.responded, (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)this.listener1.updated, (Matcher)Matchers.is((Object)4));
    }
}

