/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote.emf;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestCollectionObjectRemoteFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestEClassRemoteFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestEPackageRemoteFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteEClass;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteEPackage;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.TestRemoteEmfObserver;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RemoteEmfFactoryTest {
    private static final String LOCAL_1 = "Local Object 1";
    private static final String LOCAL_2 = "Local Object 2";
    private static final String REMOTE_1 = "Remote Object 1";
    private static final String REMOTE_2 = "Remote Object 2";
    private static final String LOCAL_KEY_1 = "localKeyFor Object 1";
    private static final String LOCAL_KEY_2 = "localKeyFor Object 2";
    private static final String REMOTE_KEY_1 = "remoteKeyFor Object 1";
    private static final String REMOTE_KEY_2 = "remoteKeyFor Object 2";
    EPackage parent = EcoreFactory.eINSTANCE.createEPackage();
    final IStatus errorStatus = new Status(4, "blah", "Blah");

    private static void checkConsumer(RemoteEmfConsumer<?, ?, String, ?, String, Integer> manager, String remoteKey, String remoteObjectString, String localKey, String localObject) {
        if (remoteKey != null) {
            Assert.assertThat((String)"Bad Remote Key", (Object)((String)manager.getRemoteKey()), (Matcher)Matchers.is((Object)remoteKey));
        } else {
            Assert.assertThat((String)"Bad Remote Key", (Object)((String)manager.getRemoteKey()), (Matcher)Matchers.nullValue());
        }
        if (remoteObjectString != null) {
            Assert.assertThat((String)"Bad Remote Object", (Object)manager.getRemoteObject(), (Matcher)Matchers.notNullValue());
        } else {
            Assert.assertThat((String)"Bad Remote Object", (Object)manager.getRemoteObject(), (Matcher)Matchers.nullValue());
        }
        if (localKey != null) {
            Assert.assertThat((String)"Bad Local Key", (Object)((String)manager.getLocalKey()), (Matcher)Matchers.is((Object)localKey));
        } else {
            Assert.assertThat((String)"Bad Local Key", (Object)((String)manager.getLocalKey()), (Matcher)Matchers.nullValue());
        }
        if (localObject != null) {
            Assert.assertThat((String)"Bad Local Object", (Object)manager.getModelObject(), (Matcher)Matchers.notNullValue());
        } else {
            Assert.assertThat((String)"Bad Local Object", (Object)manager.getModelObject(), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testRemoteProcessCreate() {
        TestEClassRemoteFactory testEClassRemoteFactory = new TestEClassRemoteFactory();
        EClass create1 = testEClassRemoteFactory.createModel(this.parent, TestEClassRemoteFactory.remote1);
        Assert.assertThat((Object)create1.getName(), (Matcher)Matchers.is((Object)LOCAL_1));
        EClass create2 = testEClassRemoteFactory.createModel(this.parent, TestEClassRemoteFactory.remote2);
        Assert.assertThat((Object)create2.getName(), (Matcher)Matchers.is((Object)LOCAL_2));
    }

    @Test
    public void testGetConsumerForRemoteKey() throws CoreException {
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
        harness.basicTest();
    }

    @Test
    public void testGetConsumerForRemoteKeyUpdate() throws CoreException {
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
        harness.basicTest();
        TestEClassRemoteFactory.remote1.data = "new";
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(2, 2);
        EClass modelObject = (EClass)harness.consumer.getModelObject();
        Assert.assertThat((Object)modelObject.getInstanceTypeName(), (Matcher)Matchers.is((Object)"new"));
    }

    @Test
    public void testGetConsumerForDifferentParentSameLocalKey() throws CoreException {
        EPackage parent1 = EcoreFactory.eINSTANCE.createEPackage();
        TestEClassRemoteFactory factory = new TestEClassRemoteFactory();
        RemoteEmfConsumer consumer1 = factory.getConsumerForRemoteKey((EObject)parent1, REMOTE_KEY_1);
        EPackage parent2 = EcoreFactory.eINSTANCE.createEPackage();
        RemoteEmfConsumer consumer2 = factory.getConsumerForRemoteKey((EObject)parent2, REMOTE_KEY_1);
        Assert.assertThat((Object)consumer1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)consumer2)));
    }

    @Test
    public void testGetConsumerForLocalKey() throws CoreException {
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForLocalKey((EObject)parent, RemoteEmfFactoryTest.LOCAL_KEY_1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, null, null, LOCAL_KEY_1, null);
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(1, 0);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, null, null, LOCAL_KEY_1, null);
    }

    @Test
    public void testGetConsumerForRemote() throws CoreException {
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteObject((EObject)parent, TestEClassRemoteFactory.remote1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, null);
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(1, 1);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, LOCAL_1);
    }

    @Test
    public void testRemoteKeyThenRemoteObject() throws CoreException {
        TestEClassRemoteFactory testEClassRemoteFactory = new TestEClassRemoteFactory();
        TestManagerEClassHarness keyHarness = new TestManagerEClassHarness(this, testEClassRemoteFactory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_2);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(keyHarness.consumer, REMOTE_KEY_2, null, LOCAL_KEY_2, null);
        TestManagerEClassHarness remoteHarness = new TestManagerEClassHarness(this, testEClassRemoteFactory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteObject((EObject)parent, TestEClassRemoteFactory.remote2);
            }
        };
        Assert.assertThat(keyHarness.consumer, (Matcher)Matchers.sameInstance(remoteHarness.consumer));
        RemoteEmfFactoryTest.checkConsumer(remoteHarness.consumer, REMOTE_KEY_2, REMOTE_2, LOCAL_KEY_2, null);
    }

    @Test
    public void testRemoteObjectThenRemoteKey() throws CoreException {
        TestEClassRemoteFactory testEClassRemoteFactory = new TestEClassRemoteFactory();
        TestManagerEClassHarness remoteHarness = new TestManagerEClassHarness(this, testEClassRemoteFactory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteObject((EObject)parent, TestEClassRemoteFactory.remote2);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(remoteHarness.consumer, REMOTE_KEY_2, REMOTE_2, LOCAL_KEY_2, null);
        TestManagerEClassHarness keyHarness = new TestManagerEClassHarness(this, testEClassRemoteFactory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_2);
            }
        };
        Assert.assertThat(keyHarness.consumer, (Matcher)Matchers.sameInstance(remoteHarness.consumer));
        RemoteEmfFactoryTest.checkConsumer(keyHarness.consumer, REMOTE_KEY_2, REMOTE_2, LOCAL_KEY_2, null);
    }

    @Test
    public void testLocalKeyThenRemoteKeyAndObject() throws CoreException {
        TestEClassRemoteFactory testEClassRemoteFactory = new TestEClassRemoteFactory();
        TestManagerEClassHarness remoteHarness = new TestManagerEClassHarness(this, testEClassRemoteFactory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForLocalKey((EObject)parent, RemoteEmfFactoryTest.LOCAL_KEY_2);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(remoteHarness.consumer, null, null, LOCAL_KEY_2, null);
        TestManagerEClassHarness keyHarness = new TestManagerEClassHarness(this, testEClassRemoteFactory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_2);
            }
        };
        Assert.assertThat(keyHarness.consumer, (Matcher)Matchers.sameInstance(remoteHarness.consumer));
        RemoteEmfFactoryTest.checkConsumer(keyHarness.consumer, REMOTE_KEY_2, null, LOCAL_KEY_2, null);
        keyHarness.consumer.retrieve(false);
        keyHarness.listener.waitForResponse(1, 1);
        RemoteEmfFactoryTest.checkConsumer(keyHarness.consumer, REMOTE_KEY_2, REMOTE_2, LOCAL_KEY_2, LOCAL_2);
    }

    @Test
    public void testLocalObjectThenRemoteKeyAndObject() {
        TestEClassRemoteFactory factory = new TestEClassRemoteFactory();
        EClass create1 = EcoreFactory.eINSTANCE.createEClass();
        create1.setName("Object 1");
        create1.setInstanceClassName(LOCAL_KEY_1);
        this.parent.getEClassifiers().add((Object)create1);
        EClass create2 = EcoreFactory.eINSTANCE.createEClass();
        create2.setName("Object 2");
        create2.setInstanceClassName(LOCAL_KEY_2);
        this.parent.getEClassifiers().add((Object)create2);
        RemoteEmfConsumer consumer = factory.getConsumerForLocalKey((EObject)this.parent, LOCAL_KEY_2);
        TestRemoteEmfObserver testListener1 = new TestRemoteEmfObserver(consumer);
        consumer.retrieve(false);
        testListener1.waitForResponse(1, 0);
        RemoteEmfFactoryTest.checkConsumer(consumer, null, null, LOCAL_KEY_2, "Object 2");
        TestManagerEClassHarness keyHarness = new TestManagerEClassHarness(this, factory){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_2);
            }
        };
        Assert.assertThat(keyHarness.consumer, (Matcher)Matchers.sameInstance((Object)consumer));
        RemoteEmfFactoryTest.checkConsumer(keyHarness.consumer, REMOTE_KEY_2, null, LOCAL_KEY_2, "Object 2");
        consumer.retrieve(false);
        testListener1.waitForResponse(2, 1);
        RemoteEmfFactoryTest.checkConsumer(keyHarness.consumer, REMOTE_KEY_2, REMOTE_2, LOCAL_KEY_2, "Object 2");
    }

    @Test
    public void testRemoteProcessFailure() throws CoreException {
        TestEClassRemoteFactory factory = new TestEClassRemoteFactory(){

            @Override
            public TestRemoteEClass pull(EPackage parent, String remoteKey, IProgressMonitor monitor) throws CoreException {
                throw new CoreException(RemoteEmfFactoryTest.this.errorStatus);
            }
        };
        RemoteEmfConsumer consumer1 = factory.getConsumerForRemoteKey((EObject)this.parent, "object1");
        TestRemoteEmfObserver testListener = new TestRemoteEmfObserver(consumer1);
        consumer1.retrieve(false);
        testListener.waitForResponse(1, 0);
        Assert.assertThat((Object)consumer1.getStatus(), (Matcher)Matchers.sameInstance((Object)this.errorStatus));
    }

    @Test
    public void testMultipleConsumers() throws CoreException {
        TestEClassRemoteFactory factory = new TestEClassRemoteFactory();
        TestManagerEClassHarness[] harnesses = new TestManagerEClassHarness[5];
        int i = 0;
        while (i < harnesses.length) {
            harnesses[i] = new TestManagerEClassHarness(factory);
            harnesses[i].basicTest();
            ++i;
        }
        i = 1;
        while (i < harnesses.length) {
            Assert.assertThat(harnesses[i].consumer, (Matcher)Matchers.sameInstance(harnesses[0].consumer));
            ++i;
        }
    }

    @Test
    public void testRemoteProcessCollectionRequestAndUpdate() throws CoreException {
        EPackage parent = EcoreFactory.eINSTANCE.createEPackage();
        TestCollectionObjectRemoteFactory factory = new TestCollectionObjectRemoteFactory();
        RemoteEmfConsumer consumer1 = factory.getConsumerForRemoteKey((EObject)parent, REMOTE_KEY_1);
        TestRemoteEmfObserver testListener = new TestRemoteEmfObserver(consumer1);
        consumer1.retrieve(false);
        testListener.waitForResponse(1, 1);
        List modelObject = (List)consumer1.getModelObject();
        Assert.assertThat((Object)modelObject.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)((EClassifier)modelObject.get(0)).getName(), (Matcher)Matchers.is((Object)"Many Remote Object 1_1"));
        Assert.assertThat((Object)((EClassifier)modelObject.get(1)).getName(), (Matcher)Matchers.is((Object)"Many Remote Object 1_2"));
        Assert.assertThat((Object)((EClassifier)modelObject.get(2)).getName(), (Matcher)Matchers.is((Object)"Many Remote Object 1_3"));
        consumer1.retrieve(false);
        testListener.waitForResponse(2, 2);
        consumer1.retrieve(false);
        testListener.waitForResponse(3, 3);
        Assert.assertThat((Object)modelObject.size(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)((EClassifier)modelObject.get(3)).getName(), (Matcher)Matchers.is((Object)"Many Remote Object 1_4"));
        Assert.assertThat((Object)((EClassifier)modelObject.get(4)).getName(), (Matcher)Matchers.is((Object)"Many Remote Object 1_5"));
    }

    @Test
    public void testRemoteKeyNoPull() throws CoreException {
        class TestNoPullFactory
        extends TestEClassRemoteFactory {
            TestNoPullFactory() {
            }

            @Override
            public TestRemoteEClass pull(EPackage parent, String remoteKey, IProgressMonitor monitor) throws CoreException {
                Assert.fail((String)"No retrieve call expected.");
                return null;
            }

            public boolean isPullNeeded(EPackage parent, EClass object, TestRemoteEClass remote) {
                return false;
            }
        }
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this, new TestNoPullFactory()){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(1, 0);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
    }

    @Test
    public void testRemoteKeyNoPullForceOnly() throws CoreException {
        class TestNoPullForceOnlyFactory
        extends TestEClassRemoteFactory {
            TestNoPullForceOnlyFactory() {
            }

            public boolean isPullNeeded(EPackage parent, EClass object, TestRemoteEClass remote) {
                return false;
            }
        }
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this, new TestNoPullForceOnlyFactory()){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(1, 0);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
        harness.consumer.retrieve(true);
        harness.listener.waitForResponse(2, 1);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, LOCAL_1);
    }

    @Test
    public void testRemoteKeyNoUpdate() throws CoreException {
        class TestPullCreateOnlyFactory
        extends TestEClassRemoteFactory {
            TestPullCreateOnlyFactory() {
            }

            public boolean isUpdateModelNeeded(EPackage parent, EClass object, TestRemoteEClass remote) {
                return false;
            }
        }
        TestManagerEClassHarness harness = new TestManagerEClassHarness(this, new TestPullCreateOnlyFactory()){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, RemoteEmfFactoryTest.REMOTE_KEY_1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, null, LOCAL_KEY_1, null);
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(1, 1);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, LOCAL_1);
        TestEClassRemoteFactory.remote1.data = "newData";
        harness.consumer.retrieve(false);
        harness.listener.waitForResponse(2, 1);
        EClass modelObject = (EClass)harness.consumer.getModelObject();
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, LOCAL_1);
        Assert.assertThat((Object)modelObject.getInstanceTypeName(), (Matcher)Matchers.is((Object)LOCAL_KEY_1));
        harness.consumer.retrieve(true);
        harness.listener.waitForResponse(3, 2);
        RemoteEmfFactoryTest.checkConsumer(harness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, LOCAL_1);
        Assert.assertThat((Object)modelObject.getInstanceTypeName(), (Matcher)Matchers.is((Object)"newData"));
    }

    @Test
    public void testParentConsumerUpdate() {
        final TestManagerEPackageHarness packageHarness = new TestManagerEPackageHarness(this){

            @Override
            RemoteEmfConsumer<EPackage, EPackage, String, TestRemoteEPackage, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteKey((EObject)parent, "remoteKeyFor Package 1");
            }
        };
        RemoteEmfFactoryTest.checkConsumer(packageHarness.consumer, "remoteKeyFor Package 1", null, "localKeyFor Package 1", null);
        packageHarness.basicTest();
        Assert.assertThat((Object)packageHarness.listener.updatedMember, (Matcher)Matchers.is((Object)0));
        TestManagerEClassHarness childHarness = new TestManagerEClassHarness(this){

            @Override
            RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
                return this.factory.getConsumerForRemoteObject((EObject)((EPackage)packageHarness.consumer.getModelObject()), TestEClassRemoteFactory.remote1);
            }
        };
        RemoteEmfFactoryTest.checkConsumer(childHarness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, null);
        childHarness.consumer.retrieve(false);
        childHarness.listener.waitForResponse(1, 1);
        RemoteEmfFactoryTest.checkConsumer(childHarness.consumer, REMOTE_KEY_1, REMOTE_1, LOCAL_KEY_1, LOCAL_1);
        Assert.assertThat((Object)packageHarness.listener.updated, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)packageHarness.listener.updatedMember, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testParentConsumerCollectionUpdate() {
        TestCollectionObjectRemoteFactory factory = new TestCollectionObjectRemoteFactory();
        RemoteEmfConsumer consumer = factory.getConsumerForRemoteKey((EObject)this.parent, REMOTE_KEY_1);
        TestRemoteEmfObserver testListener = new TestRemoteEmfObserver(consumer);
        consumer.retrieve(false);
        testListener.waitForResponse(1, 1);
        Assert.assertThat((Object)testListener.updating, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)testListener.currentlyUpdating, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)testListener.updatedMember, (Matcher)Matchers.is((Object)1));
        consumer.retrieve(true);
        testListener.waitForResponse(2, 2);
        Assert.assertThat((Object)testListener.currentlyUpdating, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)testListener.updating, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)testListener.updatedMember, (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testParentConsumerCollectionFailure() throws CoreException {
        TestCollectionObjectRemoteFactory factory = new TestCollectionObjectRemoteFactory(){

            @Override
            public TestRemoteEClass pull(EPackage parent, String remoteKey, IProgressMonitor monitor) throws CoreException {
                throw new CoreException(RemoteEmfFactoryTest.this.errorStatus);
            }
        };
        RemoteEmfConsumer consumer = factory.getConsumerForRemoteKey((EObject)this.parent, REMOTE_KEY_1);
        TestRemoteEmfObserver testListener = new TestRemoteEmfObserver(consumer);
        consumer.retrieve(false);
        testListener.waitForResponse(1, 0);
        Assert.assertThat((Object)consumer.getStatus(), (Matcher)Matchers.sameInstance((Object)this.errorStatus));
    }

    class TestManagerEClassHarness {
        TestEClassRemoteFactory factory;
        RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> consumer;
        TestRemoteEmfObserver<EPackage, EClass, String, Integer> listener;

        TestManagerEClassHarness(TestEClassRemoteFactory factory) {
            this.factory = factory;
            this.consumer = this.createConsumer();
            this.listener = new TestRemoteEmfObserver<EPackage, EClass, String, Integer>(this.consumer);
        }

        TestManagerEClassHarness() {
            this(new TestEClassRemoteFactory());
        }

        RemoteEmfConsumer<EPackage, EClass, String, TestRemoteEClass, String, Integer> createConsumer() {
            return this.factory.getConsumerForRemoteKey((EObject)RemoteEmfFactoryTest.this.parent, RemoteEmfFactoryTest.REMOTE_KEY_1);
        }

        void basicTest() {
            this.consumer.retrieve(false);
            this.listener.waitForResponse(1, 1);
            RemoteEmfFactoryTest.checkConsumer(this.consumer, RemoteEmfFactoryTest.REMOTE_KEY_1, RemoteEmfFactoryTest.REMOTE_1, RemoteEmfFactoryTest.LOCAL_KEY_1, RemoteEmfFactoryTest.LOCAL_1);
        }
    }

    class TestManagerEPackageHarness {
        TestEPackageRemoteFactory factory;
        RemoteEmfConsumer<EPackage, EPackage, String, TestRemoteEPackage, String, Integer> consumer;
        TestRemoteEmfObserver<EPackage, EPackage, String, Integer> listener;

        TestManagerEPackageHarness(TestEPackageRemoteFactory factory) {
            this.factory = factory;
            this.consumer = this.createConsumer();
            this.listener = new TestRemoteEmfObserver<EPackage, EPackage, String, Integer>(this.consumer);
        }

        TestManagerEPackageHarness() {
            this(new TestEPackageRemoteFactory());
        }

        RemoteEmfConsumer<EPackage, EPackage, String, TestRemoteEPackage, String, Integer> createConsumer() {
            return this.factory.getConsumerForRemoteKey((EObject)RemoteEmfFactoryTest.this.parent, "remoteKeyFor Package 1");
        }

        void basicTest() {
            this.consumer.retrieve(false);
            this.listener.waitForResponse(1, 1);
            RemoteEmfFactoryTest.checkConsumer(this.consumer, "remoteKeyFor Package 1", "Remote Package 1", "localKeyFor Package 1", "Local Package 1");
        }
    }
}

