/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.reviews.core.spi.remote.ReviewsDataLocator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ReviewsDataLocatorTest {
    ReviewsDataLocator reviewDataLocator = new ReviewsDataLocator(){

        public IPath getSystemDataPath() {
            return new Path(FileUtils.getTempDirectory().getAbsolutePath());
        }
    };

    @Test
    public void testFilePath() {
        IPath testPath = Path.fromOSString((String)FileUtils.getTempDirectory().getAbsolutePath());
        testPath = testPath.append("/reviews_bin/Parent/Class/123.txt");
        Assert.assertThat((Object)this.reviewDataLocator.getFilePath("Parent", "Class", "123", "txt"), (Matcher)Matchers.is((Object)testPath));
    }

    @Test
    public void testMigrate() throws IOException {
        String testPath = FileUtils.getTempDirectory().getAbsolutePath();
        File binDir = new File(String.valueOf(testPath) + "/reviews_bin");
        FileUtils.forceMkdir((File)binDir);
        File xmlDir = new File(String.valueOf(testPath) + "/reviews_xml");
        FileUtils.forceMkdir((File)xmlDir);
        File xmlFile = new File(String.valueOf(testPath) + "/reviews_xml/SomeFile.txt");
        xmlFile.createNewFile();
        File modelDir = new File(String.valueOf(testPath) + "/model");
        FileUtils.forceMkdir((File)modelDir);
        Assert.assertThat((Object)binDir.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)xmlDir.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)xmlFile.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)modelDir.exists(), (Matcher)Matchers.is((Object)true));
        this.reviewDataLocator.migrate();
        Assert.assertThat((Object)binDir.exists(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)xmlDir.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)xmlFile.exists(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)modelDir.exists(), (Matcher)Matchers.is((Object)false));
    }
}

