/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.spi.remote;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.reviews.core.spi.remote.AbstractDataLocator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDataLocatorTest {
    AbstractDataLocator testLocator = new AbstractDataLocator(){

        public IPath getSystemDataPath() {
            return new Path("/Foo/SystemRoot");
        }

        protected IPath getLocatorDataSegment() {
            return new Path("locator");
        }

        public IPath getFileScalingFragment(String fileName) {
            return new Path(String.valueOf(fileName.substring(0, 1)) + File.separator + fileName.substring(1, 2));
        }
    };

    @Test
    public void testFilePath() {
        Assert.assertThat((Object)this.testLocator.getFilePath("Parent", "Class", "123", "txt").toPortableString(), (Matcher)Matchers.is((Object)"/Foo/SystemRoot/locator/Parent/Class/1/2/123.txt"));
    }

    @Test
    public void testObjectPath() {
        Assert.assertThat((Object)this.testLocator.getObjectPath("Parent", "Class", "123").toPortableString(), (Matcher)Matchers.is((Object)"/Parent/Class/123"));
    }

    @Test
    public void testParentDir() {
        Assert.assertThat((Object)this.testLocator.getParentDir("Parent", "Class", "123").toPortableString(), (Matcher)Matchers.is((Object)"/Foo/SystemRoot/locator/Parent/Class/1/2"));
    }

    @Test
    public void testParseFileScalingFragment() {
        Assert.assertThat((Object)this.testLocator.parseScalingFragment((IPath)new Path("/Foo/SystemRoot/locator/Parent/Class/1/2/123.txt")), (Matcher)Matchers.is((Object)"1/2"));
    }

    @Test
    public void testParseFileName() {
        Assert.assertThat((Object)this.testLocator.parseFileName((IPath)new Path("/Foo/SystemRoot/locator/Parent/Class/1/2/123.txt")), (Matcher)Matchers.is((Object)"123"));
        Assert.assertThat((Object)this.testLocator.parseFileName((IPath)new Path("/Parent/Class/123.txt")), (Matcher)Matchers.is((Object)"123"));
    }

    @Test
    public void testParseContainerSegment() {
        Assert.assertThat((Object)this.testLocator.parseContainerSegment((IPath)new Path("/Foo/SystemRoot/locator/Parent/Class/1/2/123.txt")), (Matcher)Matchers.is((Object)"Parent"));
        Assert.assertThat((Object)this.testLocator.parseContainerSegment((IPath)new Path("/Parent/Class/123.txt")), (Matcher)Matchers.is((Object)"Parent"));
    }

    @Test
    public void testParseFileType() {
        Assert.assertThat((Object)this.testLocator.parseFileType((IPath)new Path("/Parent/Class/123.txt")), (Matcher)Matchers.is((Object)"Class"));
    }

    @Test
    public void testObjectPathFromFilePath() {
        Assert.assertThat((Object)this.testLocator.getObjectPathFromFilePath((IPath)new Path("/Foo/SystemRoot/locator/Parent/Class/1/2/123.txt")).toPortableString(), (Matcher)Matchers.is((Object)"/Parent/Class/123"));
        Assert.assertThat((Object)this.testLocator.getObjectPathFromFilePath((IPath)new Path("/Parent/Class/123")).toPortableString(), (Matcher)Matchers.is((Object)"/Parent/Class/123"));
    }

    @Test
    public void testFilePathFromObjectPath() {
        Assert.assertThat((Object)this.testLocator.getFilePathFromObjectPath((IPath)new Path("/Parent/Class/123.txt")).toPortableString(), (Matcher)Matchers.is((Object)"/Foo/SystemRoot/locator/Parent/Class/1/2/123.txt"));
    }
}

