/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.model;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IIndexed;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedTest {
    private ILineLocation l1;
    private ILineLocation l2;

    @Before
    public void setup() {
        this.l1 = ReviewsFactory.eINSTANCE.createLineLocation();
        ILineRange l1r1 = ReviewsFactory.eINSTANCE.createLineRange();
        l1r1.setStart(100);
        l1r1.setEnd(100);
        this.l1.getRanges().add(l1r1);
        ILineRange l1r2 = ReviewsFactory.eINSTANCE.createLineRange();
        l1r2.setStart(200);
        l1r2.setEnd(200);
        this.l1.getRanges().add(l1r2);
        Assert.assertThat((Object)this.l1.getRangeMin(), (Matcher)Matchers.is((Object)100));
        Assert.assertThat((Object)this.l1.getRangeMax(), (Matcher)Matchers.is((Object)200));
        this.l2 = ReviewsFactory.eINSTANCE.createLineLocation();
        ILineRange l2r1 = ReviewsFactory.eINSTANCE.createLineRange();
        l2r1.setStart(10000);
        l2r1.setEnd(10000);
        this.l2.getRanges().add(l2r1);
        ILineRange l2r2 = ReviewsFactory.eINSTANCE.createLineRange();
        l2r2.setStart(30);
        l2r2.setEnd(30);
        this.l2.getRanges().add(l2r2);
        Assert.assertThat((Object)this.l2.getRangeMin(), (Matcher)Matchers.is((Object)30));
        Assert.assertThat((Object)this.l2.getRangeMax(), (Matcher)Matchers.is((Object)10000));
    }

    @Test
    public void testLineLocation() {
        ArrayList<ILineLocation> orderable = new ArrayList<ILineLocation>();
        orderable.add(this.l1);
        orderable.add(this.l2);
        Collections.sort(orderable, IIndexed.COMPARATOR);
        Assert.assertThat((Object)((ILineLocation)orderable.get(0)), (Matcher)Matchers.sameInstance((Object)this.l2));
        Assert.assertThat((Object)((ILineLocation)orderable.get(1)), (Matcher)Matchers.sameInstance((Object)this.l1));
    }

    @Test
    public void testComment() {
        IComment c1 = ReviewsFactory.eINSTANCE.createComment();
        IComment c2 = ReviewsFactory.eINSTANCE.createComment();
        c1.getLocations().add(this.l1);
        c2.getLocations().add(this.l2);
        ArrayList<IComment> orderable = new ArrayList<IComment>();
        orderable.add(c1);
        orderable.add(c2);
        Collections.sort(orderable, IIndexed.COMPARATOR);
        Assert.assertThat((Object)((IComment)orderable.get(0)), (Matcher)Matchers.sameInstance((Object)c2));
        Assert.assertThat((Object)((IComment)orderable.get(1)), (Matcher)Matchers.sameInstance((Object)c1));
    }
}

