/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.core.model;

import java.util.Date;
import java.util.List;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.internal.core.model.FileItem;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CommentContainerTest {
    @Test
    public void testGetAllCommentsFileItems() {
        IFileItem f1 = ReviewsFactory.eINSTANCE.createFileItem();
        IComment comment0 = ReviewsFactory.eINSTANCE.createComment();
        f1.getComments().add(comment0);
        IComment comment1 = ReviewsFactory.eINSTANCE.createComment();
        f1.getComments().add(comment1);
        f1.setBase(ReviewsFactory.eINSTANCE.createFileVersion());
        f1.setTarget(ReviewsFactory.eINSTANCE.createFileVersion());
        IComment comment2 = ReviewsFactory.eINSTANCE.createComment();
        f1.getBase().getComments().add(comment2);
        IComment comment3 = ReviewsFactory.eINSTANCE.createComment();
        f1.getTarget().getComments().add(comment3);
        Assert.assertThat((Object)f1.getAllComments().size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)((IComment)f1.getAllComments().get(0)), (Matcher)Matchers.sameInstance((Object)comment0));
        Assert.assertThat((Object)((IComment)f1.getAllComments().get(1)), (Matcher)Matchers.sameInstance((Object)comment1));
        Assert.assertThat((Object)((IComment)f1.getAllComments().get(2)), (Matcher)Matchers.sameInstance((Object)comment2));
        Assert.assertThat((Object)((IComment)f1.getAllComments().get(3)), (Matcher)Matchers.sameInstance((Object)comment3));
    }

    @Test
    public void testGetAllCommentsReviewItems() {
        IFileItem i1 = ReviewsFactory.eINSTANCE.createFileItem();
        i1.getComments().add(ReviewsFactory.eINSTANCE.createComment());
        i1.getComments().add(ReviewsFactory.eINSTANCE.createComment());
        Assert.assertThat((Object)i1.getAllComments().size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testGetAllCommentsReviewItemSet() {
        IReviewItemSet itemSet = ReviewsFactory.eINSTANCE.createReviewItemSet();
        IFileItem i1 = IReviewsFactory.INSTANCE.createFileItem();
        IComment t0 = ReviewsFactory.eINSTANCE.createComment();
        i1.getComments().add(t0);
        IComment t1 = ReviewsFactory.eINSTANCE.createComment();
        i1.getComments().add(t1);
        itemSet.getItems().add(i1);
        Assert.assertThat((Object)itemSet.getAllComments().size(), (Matcher)Matchers.is((Object)2));
        IFileItem i2 = IReviewsFactory.INSTANCE.createFileItem();
        IComment t2 = ReviewsFactory.eINSTANCE.createComment();
        i2.getComments().add(t2);
        IComment t3 = ReviewsFactory.eINSTANCE.createComment();
        i2.getComments().add(t3);
        itemSet.getItems().add(i2);
        Assert.assertThat((Object)itemSet.getAllComments().size(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testGetAllCommentsReview() {
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        IComment t0 = ReviewsFactory.eINSTANCE.createComment();
        review.getComments().add(t0);
        Assert.assertThat((Object)review.getAllComments().size(), (Matcher)Matchers.is((Object)1));
        IReviewItemSet itemSet = ReviewsFactory.eINSTANCE.createReviewItemSet();
        review.getSets().add(itemSet);
        IFileItem i1 = IReviewsFactory.INSTANCE.createFileItem();
        IComment t1 = ReviewsFactory.eINSTANCE.createComment();
        i1.getComments().add(t1);
        IComment t2 = ReviewsFactory.eINSTANCE.createComment();
        i1.getComments().add(t2);
        itemSet.getItems().add(i1);
        Assert.assertThat((Object)review.getAllComments().size(), (Matcher)Matchers.is((Object)3));
        IFileItem i2 = IReviewsFactory.INSTANCE.createFileItem();
        IComment t3 = ReviewsFactory.eINSTANCE.createComment();
        i2.getComments().add(t3);
        IComment t4 = ReviewsFactory.eINSTANCE.createComment();
        i2.getComments().add(t4);
        itemSet.getItems().add(i2);
        Assert.assertThat((Object)review.getAllComments().size(), (Matcher)Matchers.is((Object)5));
        IReviewItemSet reviewSubSet = ReviewsFactory.eINSTANCE.createReviewItemSet();
        IFileItem i4 = IReviewsFactory.INSTANCE.createFileItem();
        IComment t5 = ReviewsFactory.eINSTANCE.createComment();
        i4.getComments().add(t5);
        t5.setId("5");
        reviewSubSet.getItems().add(i4);
        review.getSets().add(reviewSubSet);
        Assert.assertThat((Object)review.getAllComments().size(), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)((IComment)review.getAllComments().get(0)), (Matcher)Matchers.is((Object)t0));
        Assert.assertThat((Object)((IComment)review.getAllComments().get(1)), (Matcher)Matchers.is((Object)t1));
        Assert.assertThat((Object)((IComment)review.getAllComments().get(2)), (Matcher)Matchers.is((Object)t2));
        Assert.assertThat((Object)((IComment)review.getAllComments().get(3)), (Matcher)Matchers.is((Object)t3));
        Assert.assertThat((Object)((IComment)review.getAllComments().get(4)), (Matcher)Matchers.is((Object)t4));
        Assert.assertThat((Object)((IComment)review.getAllComments().get(5)), (Matcher)Matchers.is((Object)t5));
    }

    @Test
    public void testGetAllCommentReplies() {
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        IComment mainComment = ReviewsFactory.eINSTANCE.createComment();
        review.getComments().add(mainComment);
        List allComments = review.getAllComments();
        Assert.assertThat((Object)allComments.size(), (Matcher)Matchers.is((Object)1));
        IComment comment0 = ReviewsFactory.eINSTANCE.createComment();
        review.getComments().add(comment0);
        mainComment.getReplies().add(comment0);
        allComments = review.getAllComments();
        Assert.assertThat((Object)allComments.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((IComment)allComments.get(0)), (Matcher)Matchers.is((Object)mainComment));
        Assert.assertThat((Object)((IComment)allComments.get(1)), (Matcher)Matchers.is((Object)comment0));
    }

    @Test
    public void testCreateFileItemComment() {
        IRepository repos = ReviewsFactory.eINSTANCE.createRepository();
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        repos.getReviews().add(review);
        IReviewItemSet set = ReviewsFactory.eINSTANCE.createReviewItemSet();
        review.getSets().add(set);
        IFileItem item = ReviewsFactory.eINSTANCE.createFileItem();
        set.getItems().add(item);
        ILineLocation location = ReviewsFactory.eINSTANCE.createLineLocation();
        IUser fileAuthor = ReviewsFactory.eINSTANCE.createUser();
        fileAuthor.setDisplayName("Another User");
        item.setAddedBy(fileAuthor);
        IUser account = ReviewsFactory.eINSTANCE.createUser();
        account.setDisplayName("This User");
        repos.setAccount(account);
        IComment comment = item.createComment((ILocation)location, "My Comment");
        Assert.assertThat((Object)comment.getItem(), (Matcher)Matchers.instanceOf(IFileItem.class));
        Assert.assertThat((Object)comment.getReview(), (Matcher)Matchers.sameInstance((Object)review));
        Assert.assertThat((Object)((FileItem)comment.getItem()).getReview(), (Matcher)Matchers.sameInstance((Object)review));
        Assert.assertThat((Object)((FileItem)comment.getItem()).getReview().getRepository(), (Matcher)Matchers.sameInstance((Object)repos));
        Assert.assertTrue((boolean)item.getComments().contains(comment));
        Assert.assertSame((Object)comment.getItem(), (Object)item);
        Assert.assertThat((Object)comment.getDescription(), (Matcher)Matchers.is((Object)"My Comment"));
        Assert.assertThat((Object)comment.getAuthor().getDisplayName(), (Matcher)Matchers.is((Object)"This User"));
        Assert.assertTrue((new Date().getTime() - 100L < comment.getCreationDate().getTime() ? 1 : 0) != 0);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCreateFileItemCommentNoUser() {
        IFileItem item = ReviewsFactory.eINSTANCE.createFileItem();
        ILineLocation location = ReviewsFactory.eINSTANCE.createLineLocation();
        IComment comment = item.createComment((ILocation)location, "My Comment");
        Assert.assertThat((Object)item.getComments().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)comment.getAuthor(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCreateReviewCommentNoUser() {
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        ILineLocation location = ReviewsFactory.eINSTANCE.createLineLocation();
        IComment comment = review.createComment((ILocation)location, "My Comment");
        Assert.assertThat((Object)review.getComments().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertNull((Object)comment.getAuthor());
    }

    @Test
    public void testGetReviewFileItemComment() {
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        IReviewItemSet set = ReviewsFactory.eINSTANCE.createReviewItemSet();
        review.getSets().add(set);
        IFileItem item = ReviewsFactory.eINSTANCE.createFileItem();
        IComment comment = ReviewsFactory.eINSTANCE.createComment();
        set.getItems().add(item);
        item.getComments().add(comment);
        Assert.assertThat((Object)comment.getReview(), (Matcher)Matchers.sameInstance((Object)review));
    }

    @Test
    public void testGetReviewComment() {
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        IComment comment = ReviewsFactory.eINSTANCE.createComment();
        review.getComments().add(comment);
        Assert.assertThat((Object)comment.getReview(), (Matcher)Matchers.sameInstance((Object)review));
    }

    @Test
    public void testIsMineForRepositoryWithoutAccountAndCommentWithoutAuthor() {
        IComment comment = CommentContainerTest.createReviewWithComment(CommentContainerTest.createRepository());
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsMineForRepositoryAndCommentWithTheSameUser() {
        IUser user = CommentContainerTest.createUser();
        IRepository repo = CommentContainerTest.createRepositoryWithAccount(user);
        IComment comment = CommentContainerTest.createReviewWithCommentAndAuthor(repo, user);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsMineForRepositoryAndCommentWithUsersHavingTheSameEmail() {
        IUser user1 = CommentContainerTest.createUser("foo@bar.com");
        IUser user2 = CommentContainerTest.createUser("foo@bar.com");
        IRepository repo = CommentContainerTest.createRepositoryWithAccount(user1);
        IComment comment = CommentContainerTest.createReviewWithCommentAndAuthor(repo, user2);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIsMineForRepositoryWithAccountAndCommentWithoutAuthor() {
        IUser user = CommentContainerTest.createUser("foo@bar.com");
        IRepository repo = CommentContainerTest.createRepositoryWithAccount(user);
        IComment comment = CommentContainerTest.createReviewWithComment(repo);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsMineForRepositoryAndCommentWithUsersHavingTheDifferentEmails() {
        IUser user1 = CommentContainerTest.createUser("foo@bar.com");
        IUser user2 = CommentContainerTest.createUser("baz@bar.com");
        IRepository repo = CommentContainerTest.createRepositoryWithAccount(user1);
        IComment comment = CommentContainerTest.createReviewWithCommentAndAuthor(repo, user2);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsMineForRepositoryWithoutAccountAndCommentWithAuthor() {
        IUser user = CommentContainerTest.createUser("foo@bar.com");
        IRepository repo = CommentContainerTest.createRepository();
        IComment comment = CommentContainerTest.createReviewWithCommentAndAuthor(repo, user);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIsMineForRepositoryWithAccountAndNullEmailAndCommentWithAuthor() {
        IUser user1 = CommentContainerTest.createUser(null);
        IUser user2 = CommentContainerTest.createUser("baz@bar.com");
        IRepository repo = CommentContainerTest.createRepositoryWithAccount(user1);
        IComment comment = CommentContainerTest.createReviewWithCommentAndAuthor(repo, user2);
        Assert.assertThat((Object)comment.isMine(), (Matcher)Matchers.is((Object)false));
    }

    private static IRepository createRepository() {
        return ReviewsFactory.eINSTANCE.createRepository();
    }

    private static IRepository createRepositoryWithAccount(IUser user) {
        IRepository repo = CommentContainerTest.createRepository();
        repo.setAccount(user);
        return repo;
    }

    private static IComment createReviewWithComment(IRepository repos) {
        IReview review = ReviewsFactory.eINSTANCE.createReview();
        repos.getReviews().add(review);
        IReviewItemSet set = ReviewsFactory.eINSTANCE.createReviewItemSet();
        review.getSets().add(set);
        IFileItem item = ReviewsFactory.eINSTANCE.createFileItem();
        IComment comment = ReviewsFactory.eINSTANCE.createComment();
        set.getItems().add(item);
        item.getComments().add(comment);
        return comment;
    }

    private static IComment createReviewWithCommentAndAuthor(IRepository repos, IUser user) {
        IComment comment = CommentContainerTest.createReviewWithComment(repos);
        comment.setAuthor(user);
        return comment;
    }

    private static IUser createUser() {
        return ReviewsFactory.eINSTANCE.createUser();
    }

    private static IUser createUser(String email) {
        IUser user = CommentContainerTest.createUser();
        user.setEmail(email);
        return user;
    }
}

