/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.tests;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.commons.sdk.util.TestProject;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.sdk.util.AbstractResourceContextTest;
import org.eclipse.mylyn.context.sdk.util.ContextTestUtil;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.resources.ui.ResourcesUi;

public class ResourcesUiTest
extends AbstractResourceContextTest {
    protected void setUp() throws Exception {
        super.setUp();
        ResourcesUiBridgePlugin.getInterestUpdater().setSyncExec(true);
        ContextTestUtil.triggerContextUiLazyStart();
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.resources.date.modified.exclusion", false);
    }

    public void testGetProjects() throws CoreException {
        Set projects = ResourcesUi.getProjects((IInteractionContext)ContextCore.getContextManager().getActiveContext());
        ResourcesUiTest.assertEquals(Collections.emptySet(), (Object)projects);
        IFile testfile1 = this.project.getProject().getFile("testfile1");
        testfile1.create(null, true, null);
        IFile testfile2 = this.project.getProject().getFile("testfile2");
        testfile2.create(null, true, null);
        projects = ResourcesUi.getProjects((IInteractionContext)ContextCore.getContextManager().getActiveContext());
        ResourcesUiTest.assertEquals(Collections.singleton(this.project.getProject()), (Object)projects);
    }

    public void testGetProjectsInWithInvalidProject() throws CoreException, InvocationTargetException, InterruptedException {
        Set projects = ResourcesUi.getProjects((IInteractionContext)ContextCore.getContextManager().getActiveContext());
        ResourcesUiTest.assertEquals(Collections.emptySet(), (Object)projects);
        IFile testfile1 = this.project.getProject().getFile("testfile1");
        testfile1.create(null, true, null);
        IFile testfile2 = this.project.getProject().getFile("testfile2");
        testfile2.create(null, true, null);
        projects = ResourcesUi.getProjects((IInteractionContext)ContextCore.getContextManager().getActiveContext());
        ResourcesUiTest.assertEquals(Collections.singleton(this.project.getProject()), (Object)projects);
        TestProject project2 = new TestProject(String.valueOf(((Object)((Object)this)).getClass().getName()) + "Invalid");
        IFile testfile3 = project2.getProject().getFile("testfile1");
        testfile3.create(null, true, null);
        ContextCore.getContextManager().setContextCapturePaused(true);
        testfile3.delete(true, null);
        project2.getProject().delete(true, null);
        ContextCore.getContextManager().setContextCapturePaused(false);
        projects = ResourcesUi.getProjects((IInteractionContext)ContextCore.getContextManager().getActiveContext());
        ResourcesUiTest.assertEquals(Collections.singleton(this.project.getProject()), (Object)projects);
    }
}

