/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.internal.resources.ui.ResourcePatternExclusionStrategy;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;

public class ResourcePatternExclusionStrategyTest
extends TestCase {
    public void testForcedExclusionPatterns() {
        String pattern = "file:/foo";
        try {
            ResourcesUiPreferenceInitializer.addForcedExclusionPattern((String)pattern);
            ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcesUiPreferenceInitializer.getForcedExcludedResourcePatterns().contains(pattern));
            ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcesUiPreferenceInitializer.getExcludedResourcePatterns().contains(pattern));
        }
        finally {
            ResourcesUiPreferenceInitializer.removeForcedExclusionPattern((String)pattern);
        }
    }

    public void testFileUriExclusionPattern() throws URISyntaxException {
        URI uri = new URI("file:/C:");
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isUriExcluded((String)uri.toString(), (String)"file:/C:"));
        uri = new URI("file:/C:/foo/bar");
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isUriExcluded((String)uri.toString(), (String)"file:/C:"));
    }

    public void testSnapshotExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)".*"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.foo"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.foo/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.foo"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.foo/foo2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/foo.test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/d.foo"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/d.foo"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/d.foo/foo2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.foo2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.foo2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.foo2/foo3"), null, patterns));
    }

    public void testFileExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)"*.doc"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc/foo2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/d.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~d.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/d.doc2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/d.doc2/foo2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/document"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/foo3"), null, patterns));
    }

    public void testAllExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)"*"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/test"), null, patterns));
    }

    public void testAllFileExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)"*.*"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/test"), null, patterns));
    }

    public void testWildcardExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)"~*"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/~test.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/test~"), null, patterns));
    }

    public void testNoWildcardExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)"folder"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/folder/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/test/folder"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder.test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.folder"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder2"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2folder/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/test"), null, patterns));
    }

    public void testPathPrefixExclusionPattern() {
        HashSet<String> patterns = new HashSet<String>();
        patterns.add("/folder/**");
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder2/folder"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/folder/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/.doc2/test/folder"), null, patterns));
    }

    public void testPathPostfixExclusionPattern() {
        HashSet<String> patterns = new HashSet<String>();
        patterns.add("**/folder");
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder1/folder"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder1/folder/folder2/test.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/.doc2/test"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/folder2"), null, patterns));
    }

    public void testComplexExclusionPattern() {
        HashSet patterns = new HashSet();
        patterns.addAll(ResourcePatternExclusionStrategy.convertToAntPattern((String)"**/folder/***.doc"));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/test.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder/folder2/test.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertTrue((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder1/folder/folder2/test.doc"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder1/folder/folder2/test.docx"), null, patterns));
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)new Path("/folder1/folder2/folder3/test.doc"), null, patterns));
    }

    public void testInclusion() {
        Path path4 = new Path("bla/bla");
        ResourcePatternExclusionStrategyTest.assertFalse((boolean)ResourcePatternExclusionStrategy.isExcluded((IPath)path4, null, new HashSet()));
    }
}

