/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.sdk.util.AbstractResourceContextTest;
import org.eclipse.mylyn.internal.resources.ui.ResourceModifiedDateExclusionStrategy;

public class ResourceModificationDateExclusionStrategyTest
extends AbstractResourceContextTest {
    private ResourceModifiedDateExclusionStrategy exclusionStrategy;
    private IFolder folder;
    private IFile fileInFolder;
    private IFile file;

    protected void setUp() throws Exception {
        super.setUp();
        ContextCore.getContextManager().deactivateContext(this.taskId);
        this.exclusionStrategy = new ResourceModifiedDateExclusionStrategy();
        this.exclusionStrategy.init();
        this.exclusionStrategy.setEnabled(true);
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isEnabled());
        long oldDate = new Date().getTime() - 5000L;
        StringBuffer fileContents = new StringBuffer("FileContents");
        ByteArrayInputStream fileInput = new ByteArrayInputStream(fileContents.toString().getBytes("UTF-8"));
        this.file = this.project.getProject().getFile("test.txt");
        this.file.create((InputStream)fileInput, true, null);
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.file.exists());
        this.file.setLocalTimeStamp(oldDate);
        this.folder = this.project.getProject().getFolder("testFolder");
        this.folder.create(true, true, null);
        this.folder.setLocalTimeStamp(oldDate);
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.folder.exists());
        ByteArrayInputStream fileInFolderInput = new ByteArrayInputStream(fileContents.toString().getBytes("UTF-8"));
        this.fileInFolder = this.folder.getFile("test.txt");
        this.fileInFolder.create((InputStream)fileInFolderInput, true, null);
        this.fileInFolder.setLocalTimeStamp(oldDate);
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.fileInFolder.exists());
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.file.isLocal(0));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.fileInFolder.isLocal(0));
        this.manager.internalActivateContext((IInteractionContext)this.context);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.exclusionStrategy.dispose();
        this.file.delete(true, null);
        this.folder.delete(true, null);
        this.fileInFolder.delete(true, null);
        ContextCore.getContextManager().deactivateContext(this.taskId);
    }

    public void testIsExcludedFolder() {
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)ResourcesPlugin.getWorkspace().getRoot()));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.project.getProject()));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.folder));
    }

    public void testIsExcludedNotEnabled() {
        this.exclusionStrategy.setEnabled(false);
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isEnabled());
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)ResourcesPlugin.getWorkspace().getRoot()));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.project.getProject()));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.folder));
    }

    public void testIsExcludedFileNoContextActive() {
        ContextCore.getContextManager().deactivateContext(this.taskId);
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)ContextCore.getContextManager().isContextActive());
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.file));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.fileInFolder));
    }

    public void testIsExcludedFileContextActiveNoChange() {
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)ContextCore.getContextManager().isContextActive());
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.file));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.fileInFolder));
    }

    public void testIsExcludedFileContextActiveChanged() throws CoreException {
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)ContextCore.getContextManager().isContextActive());
        ResourceModificationDateExclusionStrategyTest.assertNotNull((Object)this.exclusionStrategy.getLastActivatedDate());
        this.file.setLocalTimeStamp(new Date().getTime());
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.file));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.folder));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.fileInFolder));
    }

    public void testIsExcludedFileContextActiveChangedDateRounded() throws CoreException {
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)ContextCore.getContextManager().isContextActive());
        Date lastActivatedDate = this.exclusionStrategy.getLastActivatedDate();
        ResourceModificationDateExclusionStrategyTest.assertNotNull((Object)lastActivatedDate);
        long time = lastActivatedDate.getTime();
        time = (long)((double)time - (double)time % 1000.0);
        this.file.setLocalTimeStamp(time);
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.file));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.folder));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.fileInFolder));
    }

    public void testIsExcludedFileContextActiveReallyOld() throws CoreException {
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)ContextCore.getContextManager().isContextActive());
        Date lastActivatedDate = this.exclusionStrategy.getLastActivatedDate();
        ResourceModificationDateExclusionStrategyTest.assertNotNull((Object)lastActivatedDate);
        long time = lastActivatedDate.getTime();
        this.file.setLocalTimeStamp(time -= 600000L);
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.folder));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.file));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.fileInFolder));
    }

    public void testIsExcludedFileContextActiveReallyNew() throws CoreException {
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)ContextCore.getContextManager().isContextActive());
        Date lastActivatedDate = this.exclusionStrategy.getLastActivatedDate();
        ResourceModificationDateExclusionStrategyTest.assertNotNull((Object)lastActivatedDate);
        long time = lastActivatedDate.getTime();
        this.fileInFolder.setLocalTimeStamp(time += 600000L);
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.fileInFolder));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.isExcluded((IResource)this.folder));
        ResourceModificationDateExclusionStrategyTest.assertTrue((boolean)this.exclusionStrategy.isExcluded((IResource)this.file));
    }

    public void testWasModifiedAfterNullDate() {
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.wasModifiedAfter(null, null));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.wasModifiedAfter((IResource)this.file, null));
        ResourceModificationDateExclusionStrategyTest.assertFalse((boolean)this.exclusionStrategy.wasModifiedAfter((IResource)this.folder, null));
    }
}

