/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.util.AbstractResourceContextTest;
import org.eclipse.mylyn.context.sdk.util.ContextTestUtil;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ResourceContextTest
extends AbstractResourceContextTest {
    protected void setUp() throws Exception {
        super.setUp();
        ResourcesUiBridgePlugin.getInterestUpdater().setSyncExec(true);
        ContextTestUtil.triggerContextUiLazyStart();
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.resources.date.modified.exclusion", false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        ResourcesUiBridgePlugin.getInterestUpdater().setSyncExec(false);
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.resources.date.modified.exclusion", true);
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.getWorkingSet("TestWorkingSet");
        if (workingSet != null) {
            workingSetManager.removeWorkingSet(workingSet);
        }
    }

    public void testResourceSelect() throws CoreException {
        ContextCore.getContextManager().setContextCapturePaused(true);
        IFile file = this.project.getProject().getFile("file");
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertFalse((boolean)element.getInterest().isInteresting());
        ContextCore.getContextManager().setContextCapturePaused(false);
        this.monitor.selectionChanged((IWorkbenchPart)this.navigator, (ISelection)new StructuredSelection((Object)file));
        element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertTrue((boolean)element.getInterest().isInteresting());
    }

    public void testFileNotAddedIfExcluded() throws CoreException {
        Set previousExcludions = ResourcesUiPreferenceInitializer.getExcludedResourcePatterns();
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("boring");
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(exclude);
        IFile file = this.project.getProject().getFile("boring");
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertFalse((boolean)element.getInterest().isInteresting());
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns((Set)previousExcludions);
    }

    public void testPatternNotAddedIfExcluded() throws CoreException {
        Set previousExcludions = ResourcesUiPreferenceInitializer.getExcludedResourcePatterns();
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("b*.txt");
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(exclude);
        IFile file = this.project.getProject().getFile("boring.txt");
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertFalse((boolean)element.getInterest().isInteresting());
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns((Set)previousExcludions);
    }

    public void testPatternNotAddedMatching() throws CoreException {
        Set previousExcludions = ResourcesUiPreferenceInitializer.getExcludedResourcePatterns();
        HashSet<String> exclude = new HashSet<String>();
        exclude.add("**/.*");
        exclude.add(".*");
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(exclude);
        IFile file = this.project.getProject().getFile(".boring");
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertFalse((boolean)element.getInterest().isInteresting());
        file = this.project.getProject().getFile("boring");
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertTrue((boolean)element.getInterest().isInteresting());
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns((Set)previousExcludions);
    }

    public void testFileAdded() throws CoreException {
        IFile file = this.project.getProject().getFile("new-file" + new Date().getTime() + ".txt");
        ResourceContextTest.assertFalse((boolean)file.exists());
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertTrue((boolean)element.getInterest().isInteresting());
    }

    public void testFolderAddedOnCreation() throws CoreException {
        IFolder folder = this.project.getProject().getFolder("folder");
        folder.create(true, true, null);
        ResourceContextTest.assertTrue((boolean)folder.exists());
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)folder));
        ResourceContextTest.assertTrue((boolean)element.getInterest().isInteresting());
    }

    public void testProjectClose() throws CoreException, UnsupportedEncodingException {
        IProject project2 = this.project.getProject();
        this.createRealFiles(project2);
        this.context.reset();
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
        project2.close(null);
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
    }

    public void testProjectOpen() throws CoreException, UnsupportedEncodingException {
        IProject project2 = this.project.getProject();
        this.createRealFiles(project2);
        this.context.reset();
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
        project2.close(null);
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
        project2.open(null);
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
    }

    public void testProjectDelete() throws CoreException, UnsupportedEncodingException {
        IProject project2 = this.project.getProject();
        this.createRealFiles(project2);
        this.context.reset();
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
        ResourceTestUtil.deleteProject((IProject)project2);
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
    }

    public void testWorkingSetHandledByResourceBridge() {
        IProject project2 = this.project.getProject();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.createWorkingSet("TestWorkingSet", new IAdaptable[]{project2});
        ResourceContextTest.assertTrue((boolean)this.structureBridge.acceptsObject((Object)workingSet));
        AbstractContextStructureBridge workingSetBridge = ContextCore.getStructureBridge((Object)workingSet);
        ResourceContextTest.assertEquals((String)"resource", (String)workingSetBridge.getContentType());
    }

    public void testWorkingSetFiltering() throws CoreException {
        IProject project2 = this.project.getProject();
        IFile file = project2.getFile("file");
        file.create(null, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.createWorkingSet("TestWorkingSet", new IAdaptable[]{project2});
        workingSetManager.addWorkingSet(workingSet);
        this.context.reset();
        ResourceContextTest.assertEquals((int)0, (int)this.context.getInteractionHistory().size());
        ResourceContextTest.assertTrue((boolean)this.structureBridge.canFilter((Object)workingSet));
        this.monitor.selectionChanged((IWorkbenchPart)this.navigator, (ISelection)new StructuredSelection((Object)file));
        IInteractionElement element = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ResourceContextTest.assertTrue((boolean)element.getInterest().isInteresting());
        ResourceContextTest.assertFalse((boolean)this.structureBridge.canFilter((Object)workingSet));
    }

    private void createRealFiles(IProject project) throws CoreException, UnsupportedEncodingException {
        StringBuffer fileContents = new StringBuffer("FileContents");
        ByteArrayInputStream fileInput = new ByteArrayInputStream(fileContents.toString().getBytes("UTF-8"));
        IFile file = project.getFile("test.txt");
        file.create((InputStream)fileInput, true, null);
        ResourceContextTest.assertTrue((boolean)file.exists());
        IFolder folder = project.getFolder("testFolder");
        folder.create(true, true, null);
        ResourceContextTest.assertTrue((boolean)folder.exists());
        ByteArrayInputStream fileInFolderInput = new ByteArrayInputStream(fileContents.toString().getBytes("UTF-8"));
        IFile fileInFolder = folder.getFile("test.txt");
        fileInFolder.create((InputStream)fileInFolderInput, true, null);
        ResourceContextTest.assertTrue((boolean)fileInFolder.exists());
        ResourceContextTest.assertTrue((boolean)file.isLocal(0));
        ResourceContextTest.assertTrue((boolean)fileInFolder.isLocal(0));
    }
}

