/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources.tests;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaInfo;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.util.AbstractResourceContextTest;
import org.eclipse.mylyn.internal.resources.ui.ResourceChangeMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;

public class ResourceChangeMonitorTest
extends AbstractResourceContextTest {
    private ResourceChangeMonitor changeMonitor;
    private IFolder folder;
    private IFile fileInFolder;
    private IFile file;

    protected void setUp() throws Exception {
        super.setUp();
        this.changeMonitor = new ResourceChangeMonitor();
        ResourcesUiBridgePlugin.getInterestUpdater().setSyncExec(true);
        ContextCore.getContextManager().setContextCapturePaused(true);
        this.file = this.project.getProject().getFile("test.txt");
        this.file.create(null, true, null);
        ResourceChangeMonitorTest.assertTrue((boolean)this.file.exists());
        this.folder = this.project.getProject().getFolder("testFolder");
        this.folder.create(true, true, null);
        ResourceChangeMonitorTest.assertTrue((boolean)this.folder.exists());
        this.fileInFolder = this.folder.getFile("test.txt");
        this.fileInFolder.create(null, true, null);
        ResourceChangeMonitorTest.assertTrue((boolean)this.fileInFolder.exists());
        ContextCore.getContextManager().setContextCapturePaused(false);
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.resources.date.modified.exclusion", false);
    }

    protected void tearDown() throws Exception {
        ResourcesUiBridgePlugin.getInterestUpdater().setSyncExec(false);
        super.tearDown();
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.resources.date.modified.exclusion", true);
    }

    public void testCreatedFile() throws CoreException {
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), new String[]{"/test.txt"}, 257, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.file).getHandleIdentifier((Object)this.file);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNotNull((Object)element);
        ResourceChangeMonitorTest.assertTrue((boolean)element.getInterest().isPropagated());
    }

    public void testLargeFileChangeNotAddedToContext() throws CoreException {
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add("/" + this.file.getProjectRelativePath().toPortableString());
        int i = 0;
        while (i < 10) {
            IFile newFile = this.project.getProject().getFile("test" + i + ".txt");
            newFile.create(null, true, null);
            ResourceChangeMonitorTest.assertTrue((boolean)newFile.exists());
            filePaths.add("/" + newFile.getProjectRelativePath().toPortableString());
            ++i;
        }
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), filePaths.toArray(new String[filePaths.size()]), 260, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.file).getHandleIdentifier((Object)this.file);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testLargeFileAddedNotAddedToContext() throws CoreException {
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add("/" + this.file.getProjectRelativePath().toPortableString());
        int i = 0;
        while (i < 10) {
            IFile newFile = this.project.getProject().getFile("test" + i + ".txt");
            newFile.create(null, true, null);
            ResourceChangeMonitorTest.assertTrue((boolean)newFile.exists());
            filePaths.add("/" + newFile.getProjectRelativePath().toPortableString());
            ++i;
        }
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), filePaths.toArray(new String[filePaths.size()]), 257, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.file).getHandleIdentifier((Object)this.file);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testLargeFolderAddedNotAddedToContext() throws CoreException {
        ArrayList<String> folderPaths = new ArrayList<String>();
        folderPaths.add("/" + this.folder.getProjectRelativePath().toPortableString());
        int i = 0;
        while (i < 3) {
            IFolder newFolder = this.project.getProject().getFolder("testFolder" + i);
            newFolder.create(true, true, null);
            ResourceChangeMonitorTest.assertTrue((boolean)newFolder.exists());
            folderPaths.add("/" + newFolder.getProjectRelativePath().toPortableString());
            ++i;
        }
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), folderPaths.toArray(new String[folderPaths.size()]), 257, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.folder).getHandleIdentifier((Object)this.folder);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testLargeFolderChangeNotAddedToContext() throws CoreException {
        ArrayList<String> folderPaths = new ArrayList<String>();
        folderPaths.add("/" + this.folder.getProjectRelativePath().toPortableString());
        int i = 0;
        while (i < 3) {
            IFolder newFolder = this.project.getProject().getFolder("testFolder" + i);
            newFolder.create(true, true, null);
            ResourceChangeMonitorTest.assertTrue((boolean)newFolder.exists());
            folderPaths.add("/" + newFolder.getProjectRelativePath().toPortableString());
            ++i;
        }
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), folderPaths.toArray(new String[folderPaths.size()]), 260, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.folder).getHandleIdentifier((Object)this.folder);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testFolderAdded() throws CoreException {
        ArrayList<String> folderPaths = new ArrayList<String>();
        folderPaths.add("/" + this.folder.getProjectRelativePath().toPortableString());
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), folderPaths.toArray(new String[folderPaths.size()]), 257, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.folder).getHandleIdentifier((Object)this.folder);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testModifiedFile() throws CoreException {
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), new String[]{"/test.txt"}, 260, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.file).getHandleIdentifier((Object)this.file);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNotNull((Object)element);
        ResourceChangeMonitorTest.assertTrue((boolean)element.getInterest().isPredicted());
    }

    public void testDerrivedFileChanged() throws CoreException {
        this.fileInFolder.setDerived(true, null);
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), new String[]{"/test.txt"}, 260, 4);
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.fileInFolder).getHandleIdentifier((Object)this.fileInFolder);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testDerrivedFolderChanged() throws CoreException {
        this.folder.setDerived(true, null);
        this.fileInFolder.setDerived(false, null);
        MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), null, 260, 4);
        MockResourceDelta child = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName() + "/" + this.folder.getName(), new String[]{"/" + this.folder.getName() + "/test.txt"}, 260, 2);
        delta.setChildren(new ResourceDelta[]{child});
        ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
        this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
        String handle = ContextCore.getStructureBridge((Object)this.fileInFolder).getHandleIdentifier((Object)this.folder);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        IInteractionElement element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
        handle = ContextCore.getStructureBridge((Object)this.fileInFolder).getHandleIdentifier((Object)this.fileInFolder);
        ResourceChangeMonitorTest.assertNotNull((Object)handle);
        element = this.context.get(handle);
        ResourceChangeMonitorTest.assertNull((Object)element);
    }

    public void testExcluded() throws CoreException {
        try {
            ResourcesUiPreferenceInitializer.addForcedExclusionPattern((String)"*.txt");
            MockResourceDelta delta = MockResourceDelta.createMockDelta("/" + this.project.getProject().getName(), new String[]{"/test.txt"}, 260, 4);
            ResourceChangeEvent event = new ResourceChangeEvent((Object)delta, 1, 0, (IResourceDelta)delta);
            this.changeMonitor.resourceChanged((IResourceChangeEvent)event);
            String handle = ContextCore.getStructureBridge((Object)this.file).getHandleIdentifier((Object)this.file);
            ResourceChangeMonitorTest.assertNotNull((Object)handle);
            IInteractionElement element = this.context.get(handle);
            ResourceChangeMonitorTest.assertNull((Object)element);
        }
        finally {
            ResourcesUiPreferenceInitializer.removeForcedExclusionPattern((String)"*.txt");
        }
    }

    private static class MockResourceDelta
    extends ResourceDelta {
        protected MockResourceDelta(IPath path, ResourceDeltaInfo deltaInfo) {
            super(path, deltaInfo);
        }

        static MockResourceDelta createMockDelta(String path, String[] childPaths, int status, int resourceType) {
            ResourceDeltaInfo deltaInfo = new ResourceDeltaInfo((Workspace)ResourcesPlugin.getWorkspace(), null, null);
            MockResourceDelta result = new MockResourceDelta((IPath)new Path(path), deltaInfo);
            ResourceInfo info = new ResourceInfo();
            info.setType(resourceType);
            result.setNewInfo(info);
            result.setOldInfo(info);
            HashSet<MockResourceDelta> children = new HashSet<MockResourceDelta>();
            if (childPaths != null) {
                String[] stringArray = childPaths;
                int n = childPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String childPath = stringArray[n2];
                    children.add(MockResourceDelta.createMockDelta(String.valueOf(path) + childPath, null, status, 1));
                    ++n2;
                }
            }
            result.setChildren(children.toArray(new MockResourceDelta[0]));
            result.setStatus(status);
            return result;
        }

        public void setChildren(ResourceDelta[] children) {
            super.setChildren(children);
        }
    }
}

