/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.monitor.ui.CheckActivityJob;
import org.eclipse.mylyn.internal.monitor.ui.IActivityManagerCallback;

public class CheckActivityJobTest
extends TestCase {
    private StubCallback callback;
    private TestableCheckActivityJob job;

    protected void setUp() throws Exception {
        this.callback = new StubCallback();
        this.job = new TestableCheckActivityJob(this.callback);
    }

    public void testInactivityTimeout() throws Exception {
        this.callback.lastEventTime = System.currentTimeMillis() - 201L;
        this.job.setInactivityTimeout(200);
        this.job.run();
        CheckActivityJobTest.assertFalse((boolean)this.job.isActive());
        this.job.run();
        CheckActivityJobTest.assertFalse((boolean)this.job.isActive());
        this.callback.lastEventTime = System.currentTimeMillis();
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)0L, (long)this.callback.activeTime);
        Thread.sleep(6L);
        this.job.run();
        long slept = System.currentTimeMillis() - this.callback.lastEventTime;
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertTrue((String)("expected less than 5 < activeTime < 40, got " + this.callback.activeTime + " (slept " + slept + " ms)"), (this.callback.activeTime > 5L && this.callback.activeTime < 40L ? 1 : 0) != 0);
    }

    public void testResumeFromSleepNoTimeout() throws Exception {
        this.job.setInactivityTimeout(0);
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)1L, (long)this.callback.eventCount);
        this.job.run();
        CheckActivityJobTest.assertEquals((long)2L, (long)this.callback.eventCount);
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        Thread.sleep(11L);
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertTrue((String)("expected more than 10 ms, got " + this.callback.activeTime), (this.callback.activeTime > 10L ? 1 : 0) != 0);
        CheckActivityJobTest.assertEquals((long)3L, (long)this.callback.eventCount);
    }

    public void testResumeFromSleepTimeoutNoEvent() throws Exception {
        this.callback.lastEventTime = System.currentTimeMillis();
        this.job.setInactivityTimeout(20);
        this.job.setTick(20L);
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)1L, (long)this.callback.eventCount);
        Thread.sleep(61L);
        this.job.run();
        CheckActivityJobTest.assertFalse((boolean)this.job.isActive());
        this.job.run();
        CheckActivityJobTest.assertFalse((boolean)this.job.isActive());
        CheckActivityJobTest.assertTrue((String)("expected less than 10 ms, got " + this.callback.activeTime), (this.callback.activeTime < 10L ? 1 : 0) != 0);
        CheckActivityJobTest.assertEquals((long)1L, (long)this.callback.eventCount);
        CheckActivityJobTest.assertEquals((long)this.callback.lastEventTime, (long)this.callback.startTime);
    }

    public void testResumeFromSleepTimeoutEvent() throws Exception {
        this.callback.lastEventTime = System.currentTimeMillis();
        this.job.setInactivityTimeout(20);
        this.job.setTick(20L);
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)1L, (long)this.callback.eventCount);
        Thread.sleep(41L);
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.callback.inactive);
        CheckActivityJobTest.assertFalse((boolean)this.job.isActive());
        Thread.sleep(11L);
        this.job.run();
        CheckActivityJobTest.assertFalse((boolean)this.job.isActive());
        this.callback.lastEventTime = System.currentTimeMillis();
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)1L, (long)this.callback.eventCount);
        Thread.sleep(11L);
        this.job.run();
        long slept = System.currentTimeMillis() - this.callback.lastEventTime;
        CheckActivityJobTest.assertTrue((String)("expected less than 10 < activeTime < 20, got " + this.callback.activeTime + " (slept " + slept + " ms)"), (this.callback.activeTime > 10L && this.callback.activeTime < 20L ? 1 : 0) != 0);
        CheckActivityJobTest.assertEquals((long)2L, (long)this.callback.eventCount);
    }

    public void testResumeFromSleepTimeoutEventDiscarded() throws Exception {
        this.callback.lastEventTime = System.currentTimeMillis();
        this.job.setInactivityTimeout(20);
        this.job.setTick(20L);
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        this.job.run();
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)1L, (long)this.callback.eventCount);
        this.callback.activeTime = 0L;
        Thread.sleep(61L);
        this.callback.lastEventTime = System.currentTimeMillis();
        this.job.run();
        CheckActivityJobTest.assertFalse((boolean)this.callback.inactive);
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)0L, (long)this.callback.activeTime);
        Thread.sleep(6L);
        this.job.run();
        long slept = System.currentTimeMillis() - this.callback.lastEventTime;
        CheckActivityJobTest.assertTrue((boolean)this.job.isActive());
        CheckActivityJobTest.assertEquals((long)2L, (long)this.callback.eventCount);
        CheckActivityJobTest.assertTrue((String)("expected less than 5 < activeTime < 40, got " + this.callback.activeTime + " (slept " + slept + " ms)"), (this.callback.activeTime > 5L && this.callback.activeTime < 40L ? 1 : 0) != 0);
    }

    private class StubCallback
    implements IActivityManagerCallback {
        private boolean inactive;
        private long lastEventTime;
        private long activeTime;
        private long eventCount;
        private long startTime;

        private StubCallback() {
        }

        public void addMonitoredActivityTime(long startTime, long endTime) {
            this.startTime = startTime;
            this.activeTime += endTime - startTime;
            ++this.eventCount;
        }

        public void inactive() {
            this.inactive = true;
        }

        public long getLastEventTime() {
            return this.lastEventTime;
        }

        public void active() {
        }
    }

    private class TestableCheckActivityJob
    extends CheckActivityJob {
        public TestableCheckActivityJob(IActivityManagerCallback callback) {
            super(callback);
        }

        public IStatus run() {
            return super.run((IProgressMonitor)new NullProgressMonitor());
        }

        protected boolean isEnabled() {
            return true;
        }

        public void setTick(long tick) {
            this.tick = tick;
        }

        public void reschedule() {
        }
    }
}

