/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.tests;

import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.monitor.ui.ActivityContextManager;
import org.eclipse.mylyn.monitor.ui.AbstractUserActivityMonitor;

public class ActivityContextManagerTest
extends TestCase {
    private StubMonitor monitor1;
    private StubMonitor monitor2;
    private ActivityContextManager manager;

    protected void setUp() throws Exception {
        this.monitor1 = new StubMonitor();
        this.monitor2 = new StubMonitor();
        this.manager = new ActivityContextManager(Arrays.asList(new AbstractUserActivityMonitor[]{this.monitor1, this.monitor2}));
    }

    protected void tearDown() throws Exception {
        if (this.manager != null) {
            this.manager.stop();
        }
    }

    public void testStartStop() {
        this.manager.start();
        ActivityContextManagerTest.assertTrue((boolean)this.monitor1.started);
        ActivityContextManagerTest.assertTrue((boolean)this.monitor2.started);
        this.manager.stop();
        ActivityContextManagerTest.assertFalse((boolean)this.monitor1.started);
        ActivityContextManagerTest.assertFalse((boolean)this.monitor2.started);
    }

    public void testGetInactivityTimeout() {
        this.monitor1.setLastEventTime(1L);
        this.monitor2.setLastEventTime(2L);
        ActivityContextManagerTest.assertEquals((long)1L, (long)this.manager.getLastInteractionTime());
        ActivityContextManagerTest.assertEquals((long)1L, (long)this.manager.getLastInteractionTime());
    }

    public void testGetInactivityTimeoutFailure() {
        this.monitor1.setLastEventTime(1L);
        this.monitor2.setLastEventTime(2L);
        this.manager.start();
        ActivityContextManagerTest.assertEquals((long)1L, (long)this.manager.getLastInteractionTime());
        this.monitor1.fail = true;
        ActivityContextManagerTest.assertEquals((long)2L, (long)this.manager.getLastInteractionTime());
        this.manager.stop();
        ActivityContextManagerTest.assertTrue((boolean)this.monitor1.started);
        ActivityContextManagerTest.assertFalse((boolean)this.monitor2.started);
    }

    public void testEnabled() {
        this.monitor1.enabled = false;
        this.monitor1.setLastEventTime(1L);
        this.monitor2.setLastEventTime(2L);
        ActivityContextManagerTest.assertEquals((long)2L, (long)this.manager.getLastInteractionTime());
        this.monitor2.enabled = false;
        ActivityContextManagerTest.assertEquals((long)-1L, (long)this.manager.getLastInteractionTime());
    }

    private class StubMonitor
    extends AbstractUserActivityMonitor {
        private boolean started;
        private boolean fail;
        private boolean enabled = true;

        private StubMonitor() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public long getLastInteractionTime() {
            if (this.fail) {
                throw new LinkageError();
            }
            return super.getLastInteractionTime();
        }
    }
}

