/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.util.search.TestActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.ide.ui.XmlNodeHelper;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.part.FileEditorInput;

public class XmlResultUpdaterSearchListener
extends TestActiveSearchListener {
    private List<IInteractionElement> results = null;
    private final IInteractionElement node;
    private final int degreeOfSeparation;
    private boolean gathered = false;

    public XmlResultUpdaterSearchListener(AbstractRelationProvider prov, IInteractionElement searchNode, int degreeOfSeparation) {
        super(prov);
        this.node = searchNode;
        this.degreeOfSeparation = degreeOfSeparation;
    }

    public void searchCompleted(List<?> l) {
        this.results = new ArrayList<IInteractionElement>();
        if (l.isEmpty()) {
            return;
        }
        HashMap<String, String> nodes = new HashMap<String, String>();
        if (l.get(0) instanceof FileSearchResult) {
            Object[] far;
            FileSearchResult fsr = (FileSearchResult)l.get(0);
            Object[] objectArray = far = fsr.getElements();
            int n = far.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Match[] mar = fsr.getMatches(element);
                if (element instanceof File) {
                    File f = (File)element;
                    FileEditorInput fei = new FileEditorInput((IFile)f);
                    Match[] matchArray = mar;
                    int n3 = mar.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Match m = matchArray[n4];
                        try {
                            XmlNodeHelper xnode = new XmlNodeHelper(fei.getFile().getFullPath().toString(), m.getOffset());
                            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)f.getName());
                            String handle = xnode.getHandle();
                            Object o = bridge.getObjectForHandle(handle);
                            String name = bridge.getLabel(o);
                            if (o != null) {
                                nodes.put(handle, name);
                                this.results.add(this.node);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        for (String handle : nodes.keySet()) {
            this.incrementInterest(this.node, "plugin.xml", handle, this.degreeOfSeparation);
        }
        this.gathered = true;
    }

    protected void incrementInterest(IInteractionElement node, String elementKind, String elementHandle, int degreeOfSeparation) {
        boolean predictedInterest = true;
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.PREDICTION, elementKind, elementHandle, "org.eclipse.mylyn.xml.search.references", "org.eclipse.mylyn.xml.search.references", null, (float)predictedInterest);
        ContextCore.getContextManager().processInteractionEvent(event);
    }

    public boolean resultsGathered() {
        return this.gathered;
    }

    public List<?> getResults() {
        return this.results;
    }
}

