/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests.xml;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.context.sdk.util.search.ISearchPluginTest;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.pde.ui.XmlJavaRelationProvider;
import org.eclipse.mylyn.java.tests.search.ActiveSearchNotifier;
import org.eclipse.mylyn.java.tests.search.SearchPluginTestHelper;
import org.eclipse.mylyn.java.tests.xml.XmlResultUpdaterSearchListener;

public class ResultUpdaterTest
extends TestCase
implements ISearchPluginTest {
    private IType type1;
    private IFile plugin1;
    private IJavaProject jp1;
    private static final String SOURCE_ID = "XMLSearchResultUpdaterTest";
    private SearchPluginTestHelper helper;

    protected void setUp() throws Exception {
        WorkspaceSetupHelper.setupWorkspace();
        this.jp1 = WorkspaceSetupHelper.getProject1();
        this.type1 = WorkspaceSetupHelper.getType((IJavaProject)this.jp1, (String)"org.eclipse.mylar.tests.project1.views.SampleView");
        this.plugin1 = WorkspaceSetupHelper.getFile((IJavaProject)this.jp1, (String)"plugin.xml");
        InteractionContext t = WorkspaceSetupHelper.getContext();
        ContextCore.getContextManager().activateContext(t.getHandleIdentifier());
        this.helper = new SearchPluginTestHelper(this);
    }

    protected void tearDown() throws Exception {
        WorkspaceSetupHelper.clearWorkspace();
        WorkspaceSetupHelper.clearDoiModel();
    }

    public void testRemoveFile() throws Exception {
        int dos = 4;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 3, false);
        Collection edges = searchNode.getRelations();
        ResultUpdaterTest.assertEquals((int)3, (int)edges.size());
        WorkspaceSetupHelper.delete((IResource)this.plugin1);
        Collection edgesAfterRemove = searchNode.getRelations();
        ResultUpdaterTest.assertEquals((int)0, (int)edgesAfterRemove.size());
    }

    public void testRemoveProject() throws Exception {
        int dos = 4;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 3, false);
        Collection edges = searchNode.getRelations();
        ResultUpdaterTest.assertEquals((int)3, (int)edges.size());
        WorkspaceSetupHelper.deleteProject((String)this.jp1.getProject().getName());
        Collection edgesAfterRemove = searchNode.getRelations();
        ResultUpdaterTest.assertEquals((int)0, (int)edgesAfterRemove.size());
    }

    public List<?> search(int dos, IInteractionElement node) throws IOException, CoreException {
        if (node == null) {
            return null;
        }
        XmlJavaRelationProvider prov = new XmlJavaRelationProvider();
        IActiveSearchOperation o = prov.getSearchOperation(node, 0, dos);
        if (o == null) {
            return null;
        }
        XmlResultUpdaterSearchListener l = new XmlResultUpdaterSearchListener((AbstractRelationProvider)prov, node, dos);
        SearchPluginTestHelper.search(o, (IActiveSearchListener)l);
        return l.getResults();
    }
}

