/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests.tasks;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.osgi.util.NLS;

public class JavaTaskTemplateVariableResolverTest
extends TestCase {
    protected void tearDown() throws Exception {
        TasksUiPlugin.getTaskActivityManager().deactivateActiveTask();
    }

    public void testNoTaskActive() throws Exception {
        this.canHandleTemplateResolver("${activeTaskKey}", "activeTaskKey");
        this.canHandleTemplateResolver("${activeTaskPrefix}", "activeTaskPrefix");
    }

    public void testActiveLocalTask() throws Exception {
        LocalTask task = new LocalTask("12345", "Test Task");
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task);
        this.canHandleTemplateResolver("${activeTaskKey}", "12345");
        this.canHandleTemplateResolver("${activeTaskPrefix}", "task ");
        this.canHandleTemplateResolver("${activeTaskPrefix}${activeTaskKey}", "task 12345");
        this.canHandleTemplateResolver("${activeTaskPrefix}#${activeTaskKey}", "task #12345");
    }

    public void testActiveTaskJira() throws Exception {
        MockTask task = new MockTask("http://foo.bar", "12345");
        task.setTaskKey("DEMO-2");
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task);
        this.canHandleTemplateResolver("${activeTaskKey}", "DEMO-2");
        this.canHandleTemplateResolver("${activeTaskPrefix}${activeTaskKey}", "task DEMO-2");
        this.canHandleTemplateResolver("${activeTaskPrefix} ${activeTaskKey}", "task  DEMO-2");
    }

    public void testActiveTaskIdOrKey() throws Exception {
        MockTask task = new MockTask("http://foo.bar", "12345");
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task);
        this.canHandleTemplateResolver("${activeTaskKey}", "12345");
        this.canHandleTemplateResolver("${activeTaskPrefix}", "task ");
        task.setTaskKey("foobar");
        this.canHandleTemplateResolver("${activeTaskKey}", "foobar");
    }

    private void canHandleTemplateResolver(String templateContent, String expectedResolvedTemplate) throws TemplateException, BadLocationException {
        this.canHandleTemplateResolver("java", templateContent, expectedResolvedTemplate);
        this.canHandleTemplateResolver("javadoc", templateContent, expectedResolvedTemplate);
    }

    private void canHandleTemplateResolver(String contextType, String templateContent, String expectedResolvedTemplate) throws TemplateException, BadLocationException {
        TemplateVariable[] variables;
        ContextTypeRegistry registry = JavaPlugin.getDefault().getTemplateContextRegistry();
        TemplateContextType context = registry.getContextType(contextType);
        Template template = new Template("name", "description", contextType, templateContent, false);
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = null;
        buffer = translator.translate(template);
        TemplateVariable[] templateVariableArray = variables = buffer.getVariables();
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            JavaTaskTemplateVariableResolverTest.assertTrue((String)NLS.bind((String)"No resolver found for variable ''{0}'' in template ''{1}''", (Object)variable, (Object)template), (boolean)this.canHandleVariable(context, variable));
            ++n2;
        }
        JavaTaskTemplateVariableResolverTest.assertEquals((String)expectedResolvedTemplate, (String)this.getResolveTemplate(context, template));
    }

    private boolean canHandleVariable(TemplateContextType context, TemplateVariable variable) {
        Iterator iterator = context.resolvers();
        while (iterator.hasNext()) {
            TemplateVariableResolver resolver = (TemplateVariableResolver)iterator.next();
            if (!variable.getType().equals(resolver.getType())) continue;
            return true;
        }
        return false;
    }

    private String getResolveTemplate(TemplateContextType context, Template template) throws BadLocationException, TemplateException {
        DocumentTemplateContext templateContext = new DocumentTemplateContext(context, (IDocument)new Document(), new Position(0));
        TemplateBuffer templateBuffer = null;
        templateBuffer = templateContext.evaluate(template);
        return templateBuffer.getString();
    }
}

