/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests.search;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.context.sdk.util.search.ISearchPluginTest;
import org.eclipse.mylyn.context.sdk.util.search.TestActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.java.ui.search.JavaReferencesProvider;
import org.eclipse.mylyn.java.tests.search.ActiveSearchNotifier;
import org.eclipse.mylyn.java.tests.search.SearchPluginTestHelper;

public class JavaReferencesSearchTest
extends TestCase
implements ISearchPluginTest {
    private IType type1;
    private IType type11;
    private IType type2;
    private IFile plugin1;
    private IJavaProject jp1;
    private IJavaProject jp2;
    private static final String SOURCE_ID = "JavaReferencesSearchTest";
    private SearchPluginTestHelper helper;

    protected void setUp() throws Exception {
        UiTestUtil.closeWelcomeView();
        UiTestUtil.closeAllEditors();
        WorkspaceSetupHelper.setupWorkspace();
        this.jp1 = WorkspaceSetupHelper.getProject1();
        this.jp2 = WorkspaceSetupHelper.getProject2();
        this.type1 = WorkspaceSetupHelper.getType((IJavaProject)this.jp1, (String)"org.eclipse.mylar.tests.project1.views.SampleView");
        this.type11 = WorkspaceSetupHelper.getType((IJavaProject)this.jp1, (String)"org.eclipse.mylar.tests.project1.Project1Plugin");
        this.type2 = WorkspaceSetupHelper.getType((IJavaProject)this.jp2, (String)"org.eclipse.mylar.tests.project2.builder.ToggleNatureAction");
        this.plugin1 = WorkspaceSetupHelper.getFile((IJavaProject)this.jp1, (String)"plugin.xml");
        InteractionContext context = WorkspaceSetupHelper.getContext();
        ContextCore.getContextManager().activateContext(context.getHandleIdentifier());
        this.helper = new SearchPluginTestHelper(this);
    }

    protected void tearDown() throws Exception {
        WorkspaceSetupHelper.clearDoiModel();
        ContextCore.getContextManager().deactivateContext(WorkspaceSetupHelper.getContext().getHandleIdentifier());
        JavaReferencesSearchTest.assertFalse((boolean)ContextCore.getContextManager().isContextActive());
    }

    public void testJavaReferencesSearchDOS1() throws IOException, CoreException {
        int dos = 1;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type2.getHandleIdentifier(), "java", searchNode, dos, 0, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type11.getHandleIdentifier(), "java", searchNode, dos, 0, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, this.plugin1.getFullPath().toString(), "plugin.xml", searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
    }

    public void testJavaReferencesSearchDOS2() throws CoreException, IOException {
        int dos = 2;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type2.getHandleIdentifier(), "java", searchNode, dos, 0, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type11.getHandleIdentifier(), "java", searchNode, dos, 0, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, this.plugin1.getFullPath().toString(), "plugin.xml", searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNullInteresting(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
    }

    public void testJavaReferencesSearchDOS3() throws Exception {
        int dos = 3;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type2.getHandleIdentifier(), "java", searchNode, dos, 0, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNullInteresting(notifier, this.type11.getHandleIdentifier(), "java", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.plugin1.getFullPath().toString(), "plugin.xml", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNullInteresting(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
    }

    public void testJavaReferencesSearchDOS4() throws Exception {
        int dos = 4;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type2.getHandleIdentifier(), "java", searchNode, dos, 0, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNullInteresting(notifier, this.type11.getHandleIdentifier(), "java", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.plugin1.getFullPath().toString(), "plugin.xml", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNull(notifier, searchNode, dos);
        searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNullInteresting(notifier, this.type1.getHandleIdentifier(), "java", searchNode, dos, 1, true);
    }

    public void testJavaReferencesSearchDOS5() throws IOException, CoreException {
        int dos = 5;
        CompositeInteractionContext t = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        ActiveSearchNotifier notifier = new ActiveSearchNotifier(t, SOURCE_ID);
        IInteractionElement searchNode = notifier.getElement(this.type1.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 1, true);
        searchNode = notifier.getElement(this.type2.getHandleIdentifier(), "java");
        this.helper.searchResultsNotNull(notifier, searchNode, dos, 0, true);
    }

    public List<?> search(int dos, IInteractionElement node) {
        if (node == null) {
            return null;
        }
        JavaReferencesProvider prov = new JavaReferencesProvider();
        TestActiveSearchListener l = new TestActiveSearchListener((AbstractRelationProvider)prov);
        IActiveSearchOperation o = prov.getSearchOperation(node, 2, dos);
        if (o == null) {
            return null;
        }
        SearchPluginTestHelper.search(o, (IActiveSearchListener)l);
        return l.getResults();
    }
}

