/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests.search;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.WorkspaceSetupHelper;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class ActiveSearchNotifier {
    private CompositeInteractionContext context;
    private final String source;

    public ActiveSearchNotifier(CompositeInteractionContext context, String source) {
        this.context = context;
        this.source = source;
    }

    public IInteractionElement mockLowerInterest(IInteractionElement node) {
        return this.context.addEvent(this.mockUserEvent(node.getHandleIdentifier(), node.getContentType(), this.source, -3.0f));
    }

    public IInteractionElement mockRaiseInterest(IInteractionElement node) {
        return this.context.addEvent(this.mockUserEvent(node.getHandleIdentifier(), node.getContentType(), this.source, 2.0f));
    }

    public IInteractionElement mockLowerInterest(String handle, String kind) {
        return this.mockLowerInterest(this.mockEditorSelection(handle, kind));
    }

    public IInteractionElement mockRaiseInterest(String handle, String kind) {
        return this.mockRaiseInterest(this.mockEditorSelection(handle, kind));
    }

    public IInteractionElement mockEditorSelection(String handle, String kind) {
        this.context.addEvent(this.mockSelection(handle, kind, this.source));
        return this.context.addEvent(this.mockSelection(handle, kind, this.source));
    }

    public IInteractionElement getElement(String handle, String kind) {
        IInteractionElement node = this.context.addEvent(this.mockSelection(handle, kind, this.source));
        ContextCorePlugin.getContextManager().processInteractionEvent(this.mockUserEvent(handle, kind, this.source, 1.0f / ContextCore.getCommonContextScaling().getLandmark() * -2.0f), true);
        return node;
    }

    public void clearContext() throws IOException, CoreException {
        WorkspaceSetupHelper.clearDoiModel();
        try {
            InteractionContext workspaceContext = WorkspaceSetupHelper.getContext();
            ContextCore.getContextManager().activateContext(workspaceContext.getHandleIdentifier());
            this.context = (CompositeInteractionContext)ContextCore.getContextManager().getActiveContext();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private InteractionEvent mockSelection(String handle, String kind, String origin) {
        return new InteractionEvent(InteractionEvent.Kind.SELECTION, kind, handle, origin);
    }

    private InteractionEvent mockUserEvent(String handle, String kind, String origin, float scale) {
        InteractionEvent e = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, kind, handle, origin, scale * ContextCore.getCommonContextScaling().getLandmark());
        e.getInterestContribution();
        return e;
    }
}

