/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.internal.java.ui.InterestUpdateDeltaListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class RefactoringTest
extends AbstractJavaContextTest {
    private IViewPart view;

    protected void setUp() throws Exception {
        super.setUp();
        this.view = PackageExplorerPart.openInActivePerspective();
        InterestUpdateDeltaListener.setAsyncExecMode((boolean)false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDelete() throws CoreException, InvocationTargetException, InterruptedException {
        IType type = this.project.createType(this.p1, "Refactor.java", "public class Refactor { }");
        IMethod method = type.createMethod("public void deleteMe() { }", null, true, null);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)method));
        IInteractionElement node = ContextCore.getContextManager().getElement(method.getHandleIdentifier());
        RefactoringTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.project.build();
        AbstractJavaContextTest.TestProgressMonitor monitor = new AbstractJavaContextTest.TestProgressMonitor((AbstractJavaContextTest)this);
        method.delete(true, (IProgressMonitor)monitor);
        if (!monitor.isDone()) {
            Thread.sleep(100L);
        }
        IInteractionElement deletedNode = ContextCore.getContextManager().getElement(method.getHandleIdentifier());
        RefactoringTest.assertFalse((boolean)deletedNode.getInterest().isInteresting());
    }

    public void testTypeRename() throws CoreException, InterruptedException, InvocationTargetException {
        IType type = this.project.createType(this.p1, "Refactor.java", "public class Refactor { }");
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)type));
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)type.getParent()));
        this.project.build();
        IInteractionElement node = ContextCore.getContextManager().getElement(type.getHandleIdentifier());
        IInteractionElement parentNode = ContextCore.getContextManager().getElement(type.getParent().getHandleIdentifier());
        RefactoringTest.assertTrue((boolean)node.getInterest().isInteresting());
        RefactoringTest.assertTrue((boolean)parentNode.getInterest().isInteresting());
        AbstractJavaContextTest.TestProgressMonitor monitor = new AbstractJavaContextTest.TestProgressMonitor((AbstractJavaContextTest)this);
        type.rename("NewName", true, (IProgressMonitor)monitor);
        if (!monitor.isDone()) {
            Thread.sleep(200L);
        }
        this.project.build();
        ICompilationUnit unit = this.p1.getCompilationUnit("NewName.java");
        RefactoringTest.assertNotNull((Object)unit);
        IType newType = unit.getTypes()[0];
        IInteractionElement oldParentNode = ContextCore.getContextManager().getElement(parentNode.getHandleIdentifier());
        RefactoringTest.assertFalse((boolean)oldParentNode.getInterest().isInteresting());
        IInteractionElement newParentNode = ContextCore.getContextManager().getElement(newType.getParent().getHandleIdentifier());
        RefactoringTest.assertTrue((boolean)newParentNode.getInterest().isInteresting());
    }

    public void testMethodRename() throws CoreException, InterruptedException, InvocationTargetException {
        IType type = this.project.createType(this.p1, "Refactor.java", "public class Refactor { }");
        IMethod method = type.createMethod("public void refactorMe() { }", null, true, null);
        RefactoringTest.assertTrue((boolean)method.exists());
        RefactoringTest.assertEquals((int)1, (int)type.getMethods().length);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)new StructuredSelection((Object)method));
        IInteractionElement node = ContextCore.getContextManager().getElement(method.getHandleIdentifier());
        RefactoringTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.project.build();
        AbstractJavaContextTest.TestProgressMonitor monitor = new AbstractJavaContextTest.TestProgressMonitor((AbstractJavaContextTest)this);
        method.rename("refactored", true, (IProgressMonitor)monitor);
        if (!monitor.isDone()) {
            Thread.sleep(200L);
        }
        IMethod newMethod = type.getMethods()[0];
        RefactoringTest.assertTrue((boolean)newMethod.getElementName().equals("refactored"));
        IInteractionElement newNode = ContextCore.getContextManager().getElement(newMethod.getHandleIdentifier());
        RefactoringTest.assertTrue((boolean)newNode.getInterest().isInteresting());
        IInteractionElement goneNode = ContextCore.getContextManager().getElement(node.getHandleIdentifier());
        RefactoringTest.assertFalse((boolean)goneNode.getInterest().isInteresting());
    }
}

