/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class PackageExplorerRefreshTest
extends AbstractJavaContextTest {
    private PackageExplorerPart view;
    private TreeViewer viewer;

    protected void setUp() throws Exception {
        super.setUp();
        this.view = PackageExplorerPart.openInActivePerspective();
        this.viewer = this.view.getTreeViewer();
        ContextUiPlugin.getViewerManager().setSyncRefreshMode(true);
        AbstractFocusViewAction.getActionForPart((IViewPart)this.view).update(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIsEmptyAfterDeactivation() throws JavaModelException, InterruptedException {
        IMethod m1 = this.type1.createMethod("void m111() { }", null, true, null);
        StructuredSelection sm1 = new StructuredSelection((Object)m1);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)sm1);
        this.viewer.expandAll();
        PackageExplorerRefreshTest.assertTrue((UiTestUtil.countItemsInTree((Tree)this.viewer.getTree()) > 0 ? 1 : 0) != 0);
        PackageExplorerRefreshTest.assertNotNull((Object)this.viewer.testFindItem((Object)m1));
        PackageExplorerRefreshTest.assertNotNull((Object)this.viewer.testFindItem((Object)m1.getParent()));
        this.manager.deactivateContext(this.contextId);
        AbstractFocusViewAction.getActionForPart((IViewPart)this.view).update(true);
        PackageExplorerRefreshTest.assertTrue((String)("num items: " + UiTestUtil.countItemsInTree((Tree)this.viewer.getTree())), (UiTestUtil.countItemsInTree((Tree)this.viewer.getTree()) == 0 ? 1 : 0) != 0);
        AbstractFocusViewAction.getActionForPart((IViewPart)this.view).update();
    }

    public void testFocusPackageExplorerFilterAddition() {
        AbstractFocusViewAction.getActionForPart((IViewPart)this.view).update(false);
        List<ViewerFilter> filters = Arrays.asList(this.viewer.getFilters());
        for (ViewerFilter viewerFilter : filters) {
            if (!(viewerFilter instanceof InterestFilter)) continue;
            PackageExplorerRefreshTest.fail();
        }
        AbstractFocusViewAction.getActionForPart((IViewPart)this.view).update(true);
        AbstractFocusViewAction.getActionForPart((IViewPart)this.view).update(true);
        filters = Arrays.asList(this.viewer.getFilters());
        int filterCount = 0;
        for (ViewerFilter viewerFilter : filters) {
            if (!(viewerFilter instanceof InterestFilter)) continue;
            ++filterCount;
        }
        PackageExplorerRefreshTest.assertEquals((int)1, (int)filterCount);
    }

    public void testPropagation() throws JavaModelException {
        IMethod m1 = this.type1.createMethod("void m111() { }", null, true, null);
        StructuredSelection sm1 = new StructuredSelection((Object)m1);
        this.monitor.selectionChanged((IWorkbenchPart)this.view, (ISelection)sm1);
        this.viewer.expandAll();
        PackageExplorerRefreshTest.assertNotNull((Object)this.viewer.testFindItem((Object)m1));
        PackageExplorerRefreshTest.assertNotNull((Object)this.viewer.testFindItem((Object)m1.getParent()));
    }
}

