/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.context.sdk.java.TestJavaProject;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class JavaStructureTest
extends AbstractJavaContextTest {
    private final InteractionContextManager manager = ContextCorePlugin.getContextManager();
    private JavaEditingMonitor monitor;
    private IWorkbenchPart part;
    private TestJavaProject project;
    private IPackageFragment pkg;
    private IType typeFoo;
    private IMethod caller;
    private IMethod callee;
    private InteractionContext taskscape;
    private final InteractionContextScaling scaling = new InteractionContextScaling();

    protected void setUp() throws Exception {
        this.monitor = new JavaEditingMonitor();
        this.project = new TestJavaProject(((Object)((Object)this)).getClass().getName());
        this.pkg = this.project.createPackage("pkg1");
        this.typeFoo = this.project.createType(this.pkg, "Foo.java", "public class Foo { }");
        this.caller = this.typeFoo.createMethod("void caller() { callee(); }", null, true, null);
        this.callee = this.typeFoo.createMethod("void callee() { }", (IJavaElement)this.callee, true, null);
        this.taskscape = new InteractionContext("12312", (IInteractionContextScaling)this.scaling);
        this.manager.internalActivateContext((IInteractionContext)this.taskscape);
        this.part = UiTestUtil.openResourceNavigator();
    }

    protected void tearDown() throws Exception {
        this.manager.deactivateContext("12312");
        this.monitor.dispose();
        ResourceTestUtil.deleteProject((IProject)this.project.getProject());
    }

    public void testNavigation() throws JavaModelException, PartInitException {
        CompilationUnitEditor editorPart = (CompilationUnitEditor)JavaUI.openInEditor((IJavaElement)this.caller);
        this.monitor.selectionChanged(this.part, (ISelection)new StructuredSelection((Object)this.caller));
        Document document = new Document(this.typeFoo.getCompilationUnit().getSource());
        TextSelection callerSelection = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("callee();"), "callee".length());
        editorPart.setHighlightRange(callerSelection.getOffset(), callerSelection.getLength(), true);
        this.monitor.selectionChanged((IWorkbenchPart)editorPart, (ISelection)callerSelection);
        TextSelection calleeSelection = new TextSelection((IDocument)document, this.callee.getSourceRange().getOffset(), this.callee.getSourceRange().getLength());
        editorPart.setHighlightRange(callerSelection.getOffset(), callerSelection.getLength(), true);
        this.monitor.selectionChanged((IWorkbenchPart)editorPart, (ISelection)calleeSelection);
        IInteractionElement callerNode = this.manager.getElement(this.caller.getHandleIdentifier());
        IInteractionElement calleeNode = this.manager.getElement(this.callee.getHandleIdentifier());
        JavaStructureTest.assertTrue((boolean)callerNode.getInterest().isInteresting());
        JavaStructureTest.assertTrue((boolean)calleeNode.getInterest().isInteresting());
        JavaStructureTest.assertEquals((int)1, (int)callerNode.getRelations().size());
        TextSelection callerAgain = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("callee();"), "callee".length());
        editorPart.setHighlightRange(callerAgain.getOffset(), callerAgain.getLength(), true);
        this.monitor.selectionChanged((IWorkbenchPart)editorPart, (ISelection)callerSelection);
        JavaStructureTest.assertTrue((calleeNode.getRelations().size() == 1 ? 1 : 0) != 0);
    }
}

