/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.ResourceTestUtil;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.context.sdk.java.TestJavaProject;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.mylyn.monitor.core.IInteractionEventListener;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class JavaEditingMonitorTest
extends AbstractJavaContextTest {
    private IMethod callee;
    private IMethod caller;
    private int editingCount;
    private JavaEditingMonitor monitor;
    private IPackageFragment pkg;
    private TestJavaProject project;
    private int selectingCount;
    private IType typeFoo;
    private IInteractionEventListener listener;

    protected void setUp() throws Exception {
        this.monitor = new JavaEditingMonitor();
        UiTestUtil.closeAllEditors();
        this.project = new TestJavaProject(String.valueOf(((Object)((Object)this)).getClass().getName()) + this.getName());
        this.pkg = this.project.createPackage("pkg1" + this.getName());
        this.typeFoo = this.project.createType(this.pkg, "Foo.java", "public class Foo { }");
        this.caller = this.typeFoo.createMethod("void caller() {  }", null, true, null);
        this.callee = this.typeFoo.createMethod("void callee() { }", (IJavaElement)this.callee, true, null);
        this.listener = new IInteractionEventListener(){

            public void interactionObserved(InteractionEvent event) {
                if (event.getKind() == InteractionEvent.Kind.EDIT) {
                    JavaEditingMonitorTest javaEditingMonitorTest = JavaEditingMonitorTest.this;
                    javaEditingMonitorTest.editingCount = javaEditingMonitorTest.editingCount + 1;
                } else if (event.getKind() == InteractionEvent.Kind.SELECTION) {
                    JavaEditingMonitorTest javaEditingMonitorTest = JavaEditingMonitorTest.this;
                    javaEditingMonitorTest.selectingCount = javaEditingMonitorTest.selectingCount + 1;
                }
            }

            public void startMonitoring() {
            }

            public void stopMonitoring() {
            }
        };
        MonitorUi.addInteractionListener((IInteractionEventListener)this.listener);
    }

    protected void tearDown() throws Exception {
        this.monitor.dispose();
        if (this.listener != null) {
            MonitorUi.removeInteractionListener((IInteractionEventListener)this.listener);
        }
        ResourceTestUtil.deleteProject((IProject)this.project.getProject());
    }

    public void testHandleElementEdit() throws PartInitException, JavaModelException, InterruptedException {
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.selectingCount);
        CompilationUnitEditor editorPart = (CompilationUnitEditor)JavaUI.openInEditor((IJavaElement)this.caller);
        Document document = new Document(this.typeFoo.getCompilationUnit().getSource());
        TextSelection calleeSelection = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("callee()"), "callee".length());
        editorPart.setHighlightRange(calleeSelection.getOffset(), calleeSelection.getLength(), true);
        this.monitor.resetLastSelectedElement();
        this.editingCount = 0;
        this.selectingCount = 0;
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)calleeSelection, false);
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.selectingCount);
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)calleeSelection, false);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.selectingCount);
    }

    public void testHandleElementSelection() throws PartInitException, JavaModelException, InterruptedException {
        if (CommonTestUtil.isEclipse4()) {
            return;
        }
        CompilationUnitEditor editorPart = (CompilationUnitEditor)JavaUI.openInEditor((IJavaElement)this.caller);
        Document document = new Document(this.typeFoo.getCompilationUnit().getSource());
        TextSelection calleeSelection = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("callee()"), "callee".length());
        editorPart.setHighlightRange(calleeSelection.getOffset(), calleeSelection.getLength(), true);
        this.editingCount = 0;
        this.selectingCount = 0;
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)calleeSelection, false);
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.selectingCount);
        TextSelection callerSelection = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("caller()"), "caller".length());
        editorPart.setHighlightRange(callerSelection.getOffset(), callerSelection.getLength(), true);
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)callerSelection, false);
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)2, (int)this.selectingCount);
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)callerSelection, false);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)2, (int)this.selectingCount);
    }

    public void testHandleElementSelection_e_4() throws PartInitException, JavaModelException, InterruptedException {
        if (!CommonTestUtil.isEclipse4()) {
            return;
        }
        CompilationUnitEditor editorPart = (CompilationUnitEditor)JavaUI.openInEditor((IJavaElement)this.caller);
        Document document = new Document(this.typeFoo.getCompilationUnit().getSource());
        this.monitor.resetLastSelectedElement();
        this.editingCount = 0;
        this.selectingCount = 0;
        TextSelection calleeSelection = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("callee()"), "callee".length());
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)calleeSelection, false);
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.selectingCount);
        TextSelection callerSelection = new TextSelection((IDocument)document, this.typeFoo.getCompilationUnit().getSource().indexOf("caller()"), "caller".length());
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)callerSelection, false);
        JavaEditingMonitorTest.assertEquals((int)0, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)3, (int)this.selectingCount);
        this.monitor.handleWorkbenchPartSelection((IWorkbenchPart)editorPart, (ISelection)callerSelection, false);
        JavaEditingMonitorTest.assertEquals((int)1, (int)this.editingCount);
        JavaEditingMonitorTest.assertEquals((int)3, (int)this.selectingCount);
    }
}

