/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.filters.ImportDeclarationFilter;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.java.ui.actions.FocusPackageExplorerAction;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class InterestFilterTest
extends AbstractJavaContextTest {
    private InterestFilter filter;
    private PackageExplorerPart explorer;
    private AbstractFocusViewAction applyAction;

    protected void setUp() throws Exception {
        super.setUp();
        this.explorer = PackageExplorerPart.openInActivePerspective();
        InterestFilterTest.assertNotNull((Object)this.explorer);
        this.applyAction = AbstractFocusViewAction.getActionForPart((IViewPart)this.explorer);
        InterestFilterTest.assertTrue((boolean)(this.applyAction instanceof FocusPackageExplorerAction));
    }

    public void testPreservedFilterRemovalExclusion() throws JavaModelException {
        ArrayList filterClasses = new ArrayList();
        for (ViewerFilter filter : Arrays.asList(this.explorer.getTreeViewer().getFilters())) {
            filterClasses.add(filter.getClass());
        }
        InterestFilterTest.assertTrue((boolean)filterClasses.contains(ImportDeclarationFilter.class));
        this.applyAction.update(true);
        filterClasses = new ArrayList();
        for (ViewerFilter filter : Arrays.asList(this.explorer.getTreeViewer().getFilters())) {
            filterClasses.add(filter.getClass());
        }
        InterestFilterTest.assertTrue((boolean)filterClasses.contains(ImportDeclarationFilter.class));
    }

    public void testFilterRemovalAndRestore() throws JavaModelException {
        this.applyAction.update(false);
        ViewerFilter[] previousFilters = this.explorer.getTreeViewer().getFilters();
        InterestFilterTest.assertTrue((previousFilters.length > 1 ? 1 : 0) != 0);
        ViewerFilter[] viewerFilterArray = previousFilters;
        int n = previousFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewerFilter = viewerFilterArray[n2];
            if (viewerFilter instanceof InterestFilter) {
                InterestFilterTest.fail();
            }
            ++n2;
        }
        this.applyAction.update(true);
        ViewerFilter[] afterInstall = this.explorer.getTreeViewer().getFilters();
        InterestFilterTest.assertEquals((int)3, (int)afterInstall.length);
        this.applyAction.update(false);
        ViewerFilter[] restoredFilters = this.explorer.getTreeViewer().getFilters();
        InterestFilterTest.assertEquals((int)previousFilters.length, (int)restoredFilters.length);
    }

    public void testInterestFilter() throws JavaModelException {
        this.applyAction.update(true);
        this.filter = this.applyAction.getInterestFilter();
        InterestFilterTest.assertNotNull((Object)this.filter);
        IMethod m1 = this.type1.createMethod("public void m10() { }", null, true, null);
        InterestFilterTest.assertFalse((boolean)this.filter.select((Viewer)this.explorer.getTreeViewer(), null, (Object)this.type1));
        this.monitor.selectionChanged((IWorkbenchPart)PackageExplorerPart.getFromActivePerspective(), (ISelection)new StructuredSelection((Object)this.type1));
        this.manager.internalActivateContext((IInteractionContext)this.context);
        this.monitor.selectionChanged((IWorkbenchPart)PackageExplorerPart.getFromActivePerspective(), (ISelection)new StructuredSelection((Object)this.type1));
        InterestFilterTest.assertTrue((boolean)this.filter.select((Viewer)this.explorer.getTreeViewer(), null, (Object)this.type1));
        InterestFilterTest.assertFalse((boolean)this.filter.select((Viewer)this.explorer.getTreeViewer(), null, (Object)m1));
    }
}

