/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.java.tests;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.sdk.java.AbstractJavaContextTest;
import org.eclipse.mylyn.internal.context.core.CompositeContextElement;
import org.eclipse.mylyn.internal.context.core.CompositeInteractionContext;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.LocalContextStore;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;
import org.eclipse.mylyn.internal.resources.ui.ResourceStructureBridge;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class InteractionContextManagerTest
extends AbstractJavaContextTest {
    private PackageExplorerPart explorer;
    private LocalContextStore contextStore;

    protected void setUp() throws Exception {
        super.setUp();
        this.explorer = PackageExplorerPart.openInActivePerspective();
        this.contextStore = ContextCorePlugin.getContextStore();
        InteractionContextManagerTest.assertNotNull((Object)this.explorer);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHandleToPathConversion() throws IOException {
        String handle = "https://bugs.eclipse.org/bugs-123";
        File file = this.contextStore.getFileForContext(handle);
        InteractionContextManagerTest.assertFalse((boolean)file.exists());
        file.createNewFile();
        InteractionContextManagerTest.assertTrue((boolean)file.exists());
    }

    public void testPauseAndResume() throws JavaModelException {
        ContextCore.getContextManager().setContextCapturePaused(true);
        ContextCore.getContextManager().processInteractionEvent(this.mockInterestContribution("paused", 3.0f));
        IInteractionElement paused = ContextCore.getContextManager().getElement("paused");
        InteractionContextManagerTest.assertFalse((boolean)paused.getInterest().isInteresting());
        ContextCore.getContextManager().setContextCapturePaused(false);
        ContextCore.getContextManager().processInteractionEvent(this.mockInterestContribution("paused", 3.0f));
        IInteractionElement resumed = ContextCore.getContextManager().getElement("paused");
        InteractionContextManagerTest.assertTrue((boolean)resumed.getInterest().isInteresting());
    }

    public void testActivityHistory() {
        this.manager.resetActivityMetaContext();
        InteractionContext history = this.manager.getActivityMetaContext();
        InteractionContextManagerTest.assertNotNull((Object)history);
        InteractionContextManagerTest.assertEquals((int)0, (int)this.manager.getActivityMetaContext().getInteractionHistory().size());
        this.manager.internalActivateContext(this.contextStore.loadContext("1"));
        InteractionContextManagerTest.assertEquals((int)1, (int)this.manager.getActivityMetaContext().getInteractionHistory().size());
        this.manager.deactivateContext("2");
        InteractionContextManagerTest.assertEquals((int)2, (int)this.manager.getActivityMetaContext().getInteractionHistory().size());
    }

    public void testChangeHandle() {
        ContextCore.getContextManager().processInteractionEvent(this.mockInterestContribution("old", 3.0f));
        IInteractionElement old = ContextCore.getContextManager().getElement("old");
        InteractionContextManagerTest.assertTrue((boolean)old.getInterest().isInteresting());
        ContextCore.getContextManager().getActiveContext().updateElementHandle(old, "new");
        IInteractionElement changed = ContextCore.getContextManager().getElement("new");
        InteractionContextManagerTest.assertTrue((boolean)changed.getInterest().isInteresting());
    }

    public void testCopyContext() {
        File sourceFile = this.contextStore.getFileForContext(this.context.getHandleIdentifier());
        this.context.parseEvent(this.mockSelection("1"));
        InteractionContextManagerTest.assertFalse((boolean)this.context.getInteractionHistory().isEmpty());
        this.contextStore.saveContext((IInteractionContext)this.context);
        InteractionContextManagerTest.assertTrue((boolean)sourceFile.exists());
        File toFile = this.contextStore.getFileForContext("toContext");
        InteractionContextManagerTest.assertFalse((boolean)toFile.exists());
        this.contextStore.cloneContext(this.context.getHandleIdentifier(), "toContext");
        InteractionContextManagerTest.assertTrue((boolean)toFile.exists());
        this.manager.activateContext("toContext");
        IInteractionContext toContext = this.manager.getActiveContext();
        InteractionContextManagerTest.assertFalse((boolean)toContext.getInteractionHistory().isEmpty());
        toFile.delete();
        InteractionContextManagerTest.assertFalse((boolean)toFile.delete());
        this.manager.deactivateAllContexts();
    }

    public void testHasContext() {
        this.manager.deleteContext("1");
        InteractionContextManagerTest.assertFalse((boolean)this.contextStore.getFileForContext("1").exists());
        InteractionContextManagerTest.assertFalse((boolean)this.manager.hasContext("1"));
        this.manager.internalActivateContext(this.contextStore.loadContext("1"));
        InteractionContextManagerTest.assertTrue((boolean)this.manager.isContextActive());
        this.manager.deactivateContext("1");
        InteractionContextManagerTest.assertFalse((boolean)this.manager.hasContext("1"));
        this.manager.internalActivateContext(this.contextStore.loadContext("1"));
        this.manager.processInteractionEvent(this.mockSelection());
        this.manager.deactivateContext("1");
        InteractionContextManagerTest.assertTrue((boolean)this.manager.hasContext("1"));
        this.contextStore.getFileForContext("1").delete();
    }

    public void testDelete() {
        this.manager.deleteContext("1");
        InteractionContextManagerTest.assertFalse((boolean)this.contextStore.getFileForContext("1").exists());
        InteractionContextManagerTest.assertFalse((boolean)this.manager.hasContext("1"));
        this.manager.internalActivateContext(this.contextStore.loadContext("1"));
        InteractionContextManagerTest.assertTrue((boolean)this.manager.isContextActive());
        InteractionContext activeContext = (InteractionContext)((CompositeInteractionContext)this.manager.getActiveContext()).getContextMap().values().iterator().next();
        activeContext.parseEvent(this.mockSelection());
        InteractionContextManagerTest.assertTrue((boolean)this.containsHandle(activeContext, "<mock-handle>"));
        activeContext.delete(activeContext.get("<mock-handle>"));
        InteractionContextManagerTest.assertFalse((boolean)this.containsHandle(activeContext, "<mock-handle>"));
        this.manager.deactivateContext("1");
        InteractionContextManagerTest.assertFalse((boolean)this.manager.hasContext("1"));
        this.manager.activateContext("1");
        activeContext = (InteractionContext)((CompositeInteractionContext)this.manager.getActiveContext()).getContextMap().values().iterator().next();
        InteractionContextManagerTest.assertFalse((boolean)this.containsHandle(activeContext, "<mock-handle>"));
        this.manager.internalActivateContext(this.contextStore.loadContext("1"));
        this.manager.processInteractionEvent(this.mockSelection());
        this.manager.deactivateContext("1");
        InteractionContextManagerTest.assertTrue((boolean)this.manager.hasContext("1"));
        this.contextStore.getFileForContext("1").delete();
    }

    private boolean containsHandle(InteractionContext context, String mockHandle) {
        for (IInteractionElement element : context.getAllElements()) {
            if (!element.getHandleIdentifier().equals(mockHandle)) continue;
            return true;
        }
        for (IInteractionElement element : context.getInteractionHistory()) {
            if (!element.getStructureHandle().equals(mockHandle)) continue;
            return true;
        }
        return false;
    }

    public void testPredictedInterest() {
        IInteractionElement node = ContextCore.getContextManager().getElement("doesn't exist");
        InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
        InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isPropagated());
    }

    public void testParentInterestAfterDecay() throws JavaModelException {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
        StructuredSelection sm1 = new StructuredSelection((Object)m1);
        this.monitor.selectionChanged(part, (ISelection)sm1);
        IInteractionElement node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((boolean)node.getInterest().isInteresting());
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
        IInteractionElement parent = ContextCore.getContextManager().getElement(bridge.getParentHandle(node.getHandleIdentifier()));
        InteractionContextManagerTest.assertTrue((boolean)parent.getInterest().isInteresting());
        InteractionContextManagerTest.assertTrue((boolean)parent.getInterest().isPropagated());
        int i = 0;
        while ((float)i < 1.0f / this.scaling.getDecay() * 3.0f) {
            ContextCore.getContextManager().processInteractionEvent(this.mockSelection());
            ++i;
        }
        InteractionContextManagerTest.assertFalse((boolean)ContextCore.getContextManager().getElement(m1.getHandleIdentifier()).getInterest().isInteresting());
        ContextCore.getContextManager().processInteractionEvent(this.mockSelection(m1.getHandleIdentifier()));
        InteractionContextManagerTest.assertTrue((boolean)ContextCore.getContextManager().getElement(m1.getHandleIdentifier()).getInterest().isInteresting());
    }

    public void testPropagation() throws JavaModelException, Exception {
        IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
        IInteractionElement node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, new JavaStructureBridge().getContentType(), m1.getHandleIdentifier(), "source");
        ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
        node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.project.build();
        IJavaElement parent = m1.getParent();
        IInteractionElement parentNode = ContextCore.getContextManager().getElement(parent.getHandleIdentifier());
        InteractionContextManagerTest.assertFalse((boolean)parentNode.getInterest().isInteresting());
        InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, new JavaStructureBridge().getContentType(), m1.getHandleIdentifier(), "source");
        ContextCorePlugin.getContextManager().processInteractionEvent(selectionEvent, true);
        parentNode = ContextCore.getContextManager().getElement(parent.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((boolean)parentNode.getInterest().isInteresting());
    }

    public void testPropagationBetweenResourcesAndJava() throws JavaModelException, Exception {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        IPath fullPath = this.p1.getResource().getFullPath();
        IFolder newResource = (IFolder)workspace.newResource(fullPath.append("meta-inf"), 2);
        newResource.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        fullPath = newResource.getFullPath();
        IFile file = (IFile)workspace.newResource(fullPath.append("test.xml"), 1);
        file.create(null, true, (IProgressMonitor)new NullProgressMonitor());
        ResourceStructureBridge resourceStructureBridge = new ResourceStructureBridge();
        String fileHandle = resourceStructureBridge.getHandleIdentifier((Object)file);
        IInteractionElement node = ContextCore.getContextManager().getElement(fileHandle);
        InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
        InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, resourceStructureBridge.getContentType(), fileHandle, "source");
        ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
        node = ContextCore.getContextManager().getElement(fileHandle);
        InteractionContextManagerTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.project.build();
        IProject project = file.getProject();
        String projectHandle = resourceStructureBridge.getHandleIdentifier((Object)project);
        IInteractionElement parentNode = ContextCore.getContextManager().getElement(projectHandle);
        InteractionContextManagerTest.assertFalse((boolean)parentNode.getInterest().isInteresting());
        InteractionEvent selectionEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, resourceStructureBridge.getContentType(), fileHandle, "source");
        ContextCorePlugin.getContextManager().processInteractionEvent(selectionEvent, true);
        parentNode = ContextCore.getContextManager().getElement(this.p1.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((String)"Package is not in the context", (boolean)parentNode.getInterest().isInteresting());
        parentNode = ContextCore.getContextManager().getElement(projectHandle);
        InteractionContextManagerTest.assertTrue((String)"Project is not in the context", (boolean)parentNode.getInterest().isInteresting());
    }

    public void testIncremenOfParentDoi() throws JavaModelException, Exception {
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
        IInteractionElement node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
        StructuredSelection sm1 = new StructuredSelection((Object)m1);
        this.monitor.selectionChanged(part, (ISelection)sm1);
        node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.project.build();
        IJavaElement parent = m1.getParent();
        int level = 1;
        do {
            ++level;
            IInteractionElement parentNode = ContextCore.getContextManager().getElement(parent.getHandleIdentifier());
            if (parent instanceof JavaModel) continue;
            InteractionContextManagerTest.assertEquals((String)("failed on: " + parent.getClass()), (Object)Float.valueOf(node.getInterest().getValue()), (Object)Float.valueOf(parentNode.getInterest().getValue()));
        } while ((parent = parent.getParent()) != null);
    }

    public void testIncremenOfParentDoiAfterForcedDecay() throws JavaModelException, Exception {
        IInteractionElement parentNode;
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
        IMethod m2 = this.type1.createMethod("void m2() { }", null, true, null);
        IInteractionElement node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
        this.monitor.selectionChanged(part, (ISelection)new StructuredSelection((Object)m1));
        node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((boolean)node.getInterest().isInteresting());
        IJavaElement parent = m1.getParent();
        int level = 1;
        do {
            ++level;
            parentNode = ContextCore.getContextManager().getElement(parent.getHandleIdentifier());
            if (parent instanceof JavaModel) continue;
            InteractionContextManagerTest.assertTrue((boolean)parentNode.getInterest().isInteresting());
            ContextCore.getContextManager().processInteractionEvent(this.mockInterestContribution(parentNode.getHandleIdentifier(), -2.0f * parentNode.getInterest().getValue()));
            IInteractionElement updatedParent = ContextCore.getContextManager().getElement(parent.getHandleIdentifier());
            InteractionContextManagerTest.assertFalse((boolean)updatedParent.getInterest().isInteresting());
        } while ((parent = parent.getParent()) != null);
        this.monitor.selectionChanged(part, (ISelection)new StructuredSelection((Object)m2));
        this.monitor.selectionChanged(part, (ISelection)new StructuredSelection((Object)m1));
        node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
        InteractionContextManagerTest.assertTrue((boolean)node.getInterest().isInteresting());
        this.project.build();
        parent = m1.getParent();
        level = 1;
        do {
            ++level;
            parentNode = ContextCore.getContextManager().getElement(parent.getHandleIdentifier());
            if (parent instanceof JavaModel) continue;
            InteractionContextManagerTest.assertTrue((boolean)parentNode.getInterest().isInteresting());
        } while ((parent = parent.getParent()) != null);
    }

    public void testLandmarks() throws CoreException, IOException {
        LandmarksModelListener listener = new LandmarksModelListener();
        try {
            this.manager.addListener((AbstractContextListener)listener);
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
            StructuredSelection sm1 = new StructuredSelection((Object)m1);
            this.monitor.selectionChanged(part, (ISelection)sm1);
            this.manager.processInteractionEvent(this.mockInterestContribution(m1.getHandleIdentifier(), this.scaling.getLandmark()));
            this.manager.processInteractionEvent(this.mockInterestContribution(m1.getCompilationUnit().getParent().getHandleIdentifier(), this.scaling.getLandmark()));
            this.manager.processInteractionEvent(this.mockInterestContribution(m1.getCompilationUnit().getParent().getParent().getHandleIdentifier(), this.scaling.getLandmark()));
            this.manager.processInteractionEvent(this.mockInterestContribution(m1.getCompilationUnit().getParent().getParent().getParent().getHandleIdentifier(), this.scaling.getLandmark()));
            InteractionContextManagerTest.assertEquals((int)1, (int)ContextCore.getContextManager().getActiveLandmarks().size());
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.numAdditions);
            this.manager.processInteractionEvent(this.mockInterestContribution(m1.getHandleIdentifier(), -this.scaling.getLandmark()));
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.numDeletions);
        }
        finally {
            this.manager.removeListener((AbstractContextListener)listener);
        }
    }

    public void testEventProcessWithObject() throws JavaModelException {
        InteractionContext context = new InteractionContext("global-id", (IInteractionContextScaling)new InteractionContextScaling());
        context.setContentLimitedTo("java");
        ContextCorePlugin.getContextManager().addGlobalContext((IInteractionContext)context);
        InteractionContextManagerTest.assertEquals((int)0, (int)ContextCore.getContextManager().getActiveContext().getAllElements().size());
        InteractionContextManagerTest.assertEquals((int)0, (int)context.getAllElements().size());
        ContextCorePlugin.getContextManager().processInteractionEvent((Object)this.type1, InteractionEvent.Kind.SELECTION, "<mock-origin>", (IInteractionContext)context);
        InteractionContextManagerTest.assertEquals((int)9, (int)context.getAllElements().size());
        InteractionContextManagerTest.assertEquals((int)0, (int)ContextCore.getContextManager().getActiveContext().getAllElements().size());
        ContextCorePlugin.getContextManager().removeGlobalContext((IInteractionContext)context);
    }

    public void testEventProcessWithNonExistentObject() throws JavaModelException {
        InteractionContext context = new InteractionContext("global-id", (IInteractionContextScaling)new InteractionContextScaling());
        context.setContentLimitedTo("java");
        ContextCorePlugin.getContextManager().addGlobalContext((IInteractionContext)context);
        InteractionContextManagerTest.assertEquals((int)0, (int)ContextCore.getContextManager().getActiveContext().getAllElements().size());
        InteractionContextManagerTest.assertEquals((int)0, (int)context.getAllElements().size());
        ContextCorePlugin.getContextManager().processInteractionEvent((Object)new String("non existent"), InteractionEvent.Kind.SELECTION, "<mock-origin>", (IInteractionContext)context);
        InteractionContextManagerTest.assertEquals((int)0, (int)context.getAllElements().size());
        InteractionContextManagerTest.assertEquals((int)0, (int)ContextCore.getContextManager().getActiveContext().getAllElements().size());
        ContextCorePlugin.getContextManager().removeGlobalContext((IInteractionContext)context);
    }

    public void testExplicitContextManipulationListener() throws JavaModelException {
        StubContextElementedDeletedListener listener = new StubContextElementedDeletedListener();
        try {
            this.manager.addListener((AbstractContextListener)listener);
            IMethod m1 = this.type1.createMethod("void m1() { }", null, true, null);
            IInteractionElement node = ContextCore.getContextManager().getElement(m1.getHandleIdentifier());
            InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
            InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, new JavaStructureBridge().getContentType(), m1.getHandleIdentifier(), "source");
            IInteractionElement element = ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            this.manager.manipulateInterestForElement(element, true, false, true, "test", false);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            this.manager.manipulateInterestForElement(element, false, false, true, "test", false);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.implicitDeletionEventCount);
            listener.reset();
            this.manager.manipulateInterestForElement(element, true, false, true, "test", false);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            this.manager.manipulateInterestForElement(element, false, false, true, "test", true);
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            listener.reset();
            ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            this.manager.deleteElements(Collections.singleton(element), false);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.implicitDeletionEventCount);
            listener.reset();
            ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            this.manager.deleteElements(Collections.singleton(element), true);
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            listener.reset();
            ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.implicitDeletionEventCount);
            this.manager.deleteElements(Collections.singleton(element));
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.implicitDeletionEventCount);
        }
        finally {
            this.manager.removeListener((AbstractContextListener)listener);
        }
    }

    public void testRemoveProjectFromContextRemovesOnlyInteresting() throws JavaModelException {
        StubContextElementedDeletedListener listener = new StubContextElementedDeletedListener();
        try {
            this.manager.addListener((AbstractContextListener)listener);
            this.type1.createMethod("void m1() { }", null, true, null);
            this.type1.createMethod("void m2() { }", null, true, null);
            this.type1.createMethod("void m4() { }", null, true, null);
            this.type1.createMethod("void m5() { }", null, true, null);
            IJavaProject project = this.type1.getJavaProject();
            IInteractionElement node = ContextCore.getContextManager().getElement(project.getHandleIdentifier());
            InteractionContextManagerTest.assertFalse((boolean)node.getInterest().isInteresting());
            InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, new JavaStructureBridge().getContentType(), project.getHandleIdentifier(), "source");
            IInteractionElement element = ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.elementCount);
            this.manager.manipulateInterestForElements(Collections.singletonList(element), false, false, false, "test", ContextCorePlugin.getContextManager().getActiveContext(), true);
            InteractionContextManagerTest.assertEquals((int)1, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)2, (int)listener.elementCount);
        }
        finally {
            this.manager.removeListener((AbstractContextListener)listener);
        }
    }

    public void testDeleteElementsFromContext() {
        StubContextElementedDeletedListener listener = new StubContextElementedDeletedListener();
        try {
            this.manager.addListener((AbstractContextListener)listener);
            IJavaProject project = this.type1.getJavaProject();
            InteractionEvent event = new InteractionEvent(InteractionEvent.Kind.MANIPULATION, new JavaStructureBridge().getContentType(), project.getHandleIdentifier(), "source");
            IInteractionElement element = ContextCorePlugin.getContextManager().processInteractionEvent(event, true);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.explicitDeletionEventCount);
            InteractionContextManagerTest.assertEquals((int)0, (int)listener.elementCount);
            IInteractionElement originalElement = ContextCorePlugin.getContextManager().getElement(element.getHandleIdentifier());
            InteractionContextManagerTest.assertEquals((Object)element, (Object)originalElement);
            InteractionContextManagerTest.assertTrue((boolean)(originalElement instanceof CompositeContextElement));
            InteractionContextManagerTest.assertEquals((int)1, (int)((CompositeContextElement)originalElement).getNodes().size());
            ContextCorePlugin.getContextManager().deleteElements(Arrays.asList(element));
            IInteractionElement deletedElement = ContextCorePlugin.getContextManager().getElement(element.getHandleIdentifier());
            InteractionContextManagerTest.assertTrue((boolean)(deletedElement instanceof CompositeContextElement));
            InteractionContextManagerTest.assertEquals((int)0, (int)((CompositeContextElement)deletedElement).getNodes().size());
        }
        finally {
            this.manager.removeListener((AbstractContextListener)listener);
        }
    }

    class LandmarksModelListener
    extends AbstractContextListener {
        public int numAdditions = 0;
        public int numDeletions = 0;

        LandmarksModelListener() {
        }

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case LANDMARKS_ADDED: {
                    this.numAdditions += event.getElements().size();
                    break;
                }
                case LANDMARKS_REMOVED: {
                    this.numDeletions += event.getElements().size();
                }
            }
        }
    }

    private class StubContextElementedDeletedListener
    extends AbstractContextListener {
        private int explicitDeletionEventCount;
        private int implicitDeletionEventCount;
        private int elementCount;

        private StubContextElementedDeletedListener() {
        }

        void reset() {
            this.implicitDeletionEventCount = 0;
            this.explicitDeletionEventCount = 0;
            this.elementCount = 0;
        }

        public void contextChanged(ContextChangeEvent event) {
            switch (event.getEventKind()) {
                case LANDMARKS_REMOVED: 
                case ELEMENTS_DELETED: {
                    if (event.isExplicitManipulation()) {
                        ++this.explicitDeletionEventCount;
                    } else {
                        ++this.implicitDeletionEventCount;
                    }
                    this.elementCount += event.getElements().size();
                }
            }
        }
    }
}

