/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.support;

import java.util.List;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonException;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;

public class HudsonTestUtil {
    private static final long POLL_TIMEOUT = 60000L;
    private static final long POLL_INTERVAL = 3000L;

    public static void assertContains(List<HudsonModelJob> jobs, String name) {
        for (HudsonModelJob job : jobs) {
            if (!job.getName().equals(name)) continue;
            return;
        }
        Assert.fail((String)("Expected '" + name + "' in " + jobs));
    }

    public static void assertContainsNot(List<HudsonModelJob> jobs, String name) {
        for (HudsonModelJob job : jobs) {
            if (!job.getName().equals(name)) continue;
            Assert.fail((String)("Not expected '" + name + "' in " + jobs));
        }
    }

    public static void assertHealthReport(List<HudsonModelJob> jobs) {
        for (HudsonModelJob job : jobs) {
            if (job.getHealthReport().isEmpty()) continue;
            return;
        }
        Assert.fail((String)("Expected attribute 'healthReport' in " + jobs));
    }

    public static <T> T poll(Callable<T> callable) throws Exception {
        AssertionError lastException = null;
        long startTime = System.currentTimeMillis();
        int badGatewayCounter = 3;
        while (System.currentTimeMillis() - startTime < 60000L) {
            try {
                return callable.call();
            }
            catch (AssertionError e) {
                lastException = e;
            }
            catch (HudsonException e) {
                if (e.getMessage().contains("Bad Gateway") && badGatewayCounter-- > 0) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.hudson.tests", "Bad Gateway #" + badGatewayCounter, (Throwable)e));
                }
                throw e;
            }
            Thread.sleep(3000L);
        }
        if (lastException != null) {
            throw lastException;
        }
        return callable.call();
    }
}

