/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.support;

import java.util.concurrent.Callable;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.hudson.tests.support.HudsonFixture;
import org.eclipse.mylyn.hudson.tests.support.HudsonTestUtil;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonException;
import org.eclipse.mylyn.internal.hudson.core.client.RestfulHudsonClient;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBallColor;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBuild;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRun;
import org.junit.Assert;

public class HudsonHarness {
    private static final String PLAN_DISABLED = "test-disabled";
    private static final String PLAN_FAILING = "test-failing";
    private static final String PLAN_PARAMETERIZED = "test-parameterized";
    private static final String PLAN_SUCCEEDING = "test-succeeding";
    private static final String PLAN_WHITESPACE = "test-white space";
    private static final String PLAN_GIT = "test-git";
    private static final String PLAN_FOLDER = "test-folder";
    private static final String PLAN_SUB_FOLDER = "test-sub-folder";
    private static final String PLAN_NESTED_ONE = "test-nested-one";
    private static final String PLAN_NESTED_TWO = "test-nested-two";
    private RestfulHudsonClient client;
    private final HudsonFixture fixture;

    public HudsonHarness(HudsonFixture fixture) {
        this.fixture = fixture;
    }

    public RestfulHudsonClient connect() throws Exception {
        return this.connect(CommonTestUtil.PrivilegeLevel.USER);
    }

    public RestfulHudsonClient connect(CommonTestUtil.PrivilegeLevel level) throws Exception {
        this.client = HudsonFixture.connect(this.fixture.location(level));
        return this.client;
    }

    public RestfulHudsonClient privilegedClient() throws Exception {
        return HudsonFixture.connect(this.fixture.location(CommonTestUtil.PrivilegeLevel.USER));
    }

    public void dispose() {
    }

    public HudsonFixture getFixture() {
        return this.fixture;
    }

    public HudsonModelJob getJob(String name) throws HudsonException {
        return this.getJob(this.client, name);
    }

    private HudsonModelJob getJob(RestfulHudsonClient client, String name) throws HudsonException {
        for (HudsonModelJob job : client.getJobs(null, null)) {
            if (!job.getName().equals(name)) continue;
            return job;
        }
        return null;
    }

    public HudsonModelBuild getBuild(String jobName, int buildNumber) throws HudsonException {
        HudsonModelJob job = this.getJob(this.client, jobName);
        if (job == null) {
            return null;
        }
        HudsonModelBuild build = new HudsonModelBuild();
        build.setNumber(buildNumber);
        return this.getBuild(this.client, job, build);
    }

    private HudsonModelBuild getBuild(RestfulHudsonClient client, HudsonModelJob job, HudsonModelBuild build) throws HudsonException {
        return client.getBuild(job, (HudsonModelRun)build, null);
    }

    public String getPlanDisabled() {
        return PLAN_DISABLED;
    }

    public String getPlanFailing() {
        return PLAN_FAILING;
    }

    public String getPlanParameterized() {
        return PLAN_PARAMETERIZED;
    }

    public String getPlanSucceeding() {
        return PLAN_SUCCEEDING;
    }

    public String getPlanWhitespace() {
        return PLAN_WHITESPACE;
    }

    public String getPlanGit() {
        return PLAN_GIT;
    }

    public String getPlanFolder() {
        return PLAN_FOLDER;
    }

    public String getPlanSubFolder() {
        return PLAN_SUB_FOLDER;
    }

    public String getPlanNestedOne() {
        return PLAN_NESTED_ONE;
    }

    public String getPlanNestedTwo() {
        return PLAN_NESTED_TWO;
    }

    public HudsonModelJob ensureHasRun(final String plan) throws Exception {
        final RestfulHudsonClient privilegedClient = this.privilegedClient();
        HudsonModelJob job = this.getJob(privilegedClient, plan);
        if (job.getLastCompletedBuild() == null) {
            privilegedClient.runBuild(job, null, null);
            job = HudsonTestUtil.poll(new Callable<HudsonModelJob>(){

                @Override
                public HudsonModelJob call() throws Exception {
                    HudsonModelJob job = HudsonHarness.this.getJob(privilegedClient, plan);
                    Assert.assertNotNull((Object)job.getLastCompletedBuild());
                    return job;
                }
            });
        }
        return job;
    }

    public HudsonModelBallColor getSuccessColor() {
        if (this.getFixture().isHudson() && this.getFixture().getVersion().compareTo("3.0.1") >= 0) {
            return HudsonModelBallColor.GREEN;
        }
        return HudsonModelBallColor.BLUE;
    }

    public HudsonModelBallColor getSuccessAnimeColor() {
        if (this.getFixture().isHudson() && this.getFixture().getVersion().compareTo("3.0.1") >= 0) {
            return HudsonModelBallColor.GREEN_ANIME;
        }
        return HudsonModelBallColor.BLUE_ANIME;
    }

    public HudsonModelBallColor getAbortedColor() {
        return HudsonModelBallColor.ABORTED;
    }
}

