/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.support;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.mylyn.commons.sdk.util.RepositoryTestFixture;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.hudson.tests.support.HudsonHarness;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonConfigurationCache;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonServerInfo;
import org.eclipse.mylyn.internal.hudson.core.client.RestfulHudsonClient;

public class HudsonFixture
extends RepositoryTestFixture {
    public static final HudsonFixture DEFAULT = HudsonFixture.discoverDefault();
    private static HudsonFixture current;
    private final String version;
    private final HudsonServerInfo.Type type;

    private static HudsonFixture discoverDefault() {
        try {
            return (HudsonFixture)((Object)TestConfiguration.getDefault().discoverDefault(HudsonFixture.class, "hudson"));
        }
        catch (RuntimeException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.hudson.core", "No default hudson fixture found, will look for default jenkins fixture", (Throwable)e));
            return (HudsonFixture)((Object)TestConfiguration.getDefault().discoverDefault(HudsonFixture.class, "jenkins"));
        }
    }

    public static HudsonFixture current() {
        if (current == null) {
            DEFAULT.activate();
        }
        return current;
    }

    public HudsonFixture(String url, String version, HudsonServerInfo.Type type, String info) {
        super("org.eclipse.mylyn.hudson", url);
        this.version = version;
        this.type = type;
        this.setInfo(type.toString(), version, info);
        this.setUseCertificateAuthentication(info.contains("Certificate Authentication"));
    }

    public HudsonFixture(FixtureConfiguration configuration) {
        this(configuration.getUrl(), configuration.getVersion(), HudsonServerInfo.Type.valueOf((String)configuration.getType().toUpperCase()), configuration.getInfo());
    }

    protected HudsonFixture activate() {
        current = this;
        return this;
    }

    public HudsonHarness createHarness() {
        return new HudsonHarness(this);
    }

    public RestfulHudsonClient connect() throws Exception {
        return HudsonFixture.connect(this.location());
    }

    public static RestfulHudsonClient connect(RepositoryLocation location) {
        return new RestfulHudsonClient(location, new HudsonConfigurationCache());
    }

    protected HudsonFixture getDefault() {
        return DEFAULT;
    }

    public HudsonServerInfo.Type getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean canAuthenticate() {
        return true;
    }

    public boolean isHudson() {
        return HudsonServerInfo.Type.HUDSON == this.getType();
    }
}

