/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.integration;

import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.builds.core.IBooleanParameterDefinition;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.BuildPlanRequest;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.hudson.core.HudsonCore;
import org.eclipse.mylyn.hudson.tests.support.HudsonFixture;
import org.eclipse.mylyn.hudson.tests.support.HudsonHarness;

public class HudsonIntegrationTest
extends TestCase {
    private HudsonHarness harness;

    protected void setUp() throws Exception {
        this.harness = HudsonFixture.current().createHarness();
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testPlanParameters() throws Exception {
        RepositoryLocation location = this.harness.getFixture().location();
        BuildServerBehaviour behaviour = HudsonCore.createConnector(null).getBehaviour(location);
        BuildPlanRequest request = new BuildPlanRequest(Collections.singletonList(this.harness.getPlanParameterized()));
        List plans = behaviour.getPlans(request, null);
        HudsonIntegrationTest.assertEquals((String)("Expected one plan, got: " + plans), (int)1, (int)plans.size());
        IBuildPlan plan = (IBuildPlan)plans.get(0);
        HudsonIntegrationTest.assertEquals((String)this.harness.getPlanParameterized(), (String)plan.getName());
        List parameters = plan.getParameterDefinitions();
        IBooleanParameterDefinition booleanParameter = BuildFactory.eINSTANCE.createBooleanParameterDefinition();
        booleanParameter.setName("Boolean Parameter");
        booleanParameter.setDescription("Boolean Parameter Description.");
        booleanParameter.setDefaultValue(true);
        booleanParameter.setContainingBuildPlan(plan);
        this.assertEObjectsEquals(booleanParameter, parameters.get(0));
    }

    private void assertEObjectsEquals(Object o1, Object o2) {
        boolean equals = EcoreUtil.equals((EObject)((EObject)o1), (EObject)((EObject)o2));
        if (!equals) {
            HudsonIntegrationTest.assertEquals((String)o1.toString(), (String)o2.toString());
        }
    }
}

