/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.core;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.hudson.core.HudsonServerBehaviour;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonConfigurationCache;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBallColor;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelHealthReport;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;
import org.junit.Assert;

public class HudsonServerBehaviourTest
extends TestCase {
    public void testParseJobHealthNoReport() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob job = new HudsonModelJob();
        job.setUrl(String.valueOf(behaviour.getLocation().getUrl()) + "/job/test-job");
        job.setColor(HudsonModelBallColor.YELLOW);
        HudsonServerBehaviourTest.assertEquals((int)-1, (int)behaviour.parseJob(job).getHealth());
    }

    public void testParseJobHealth() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob job = new HudsonModelJob();
        job.setUrl(String.valueOf(behaviour.getLocation().getUrl()) + "/job/test-job");
        job.setColor(HudsonModelBallColor.YELLOW);
        HudsonModelHealthReport healthReport = new HudsonModelHealthReport();
        healthReport.setScore(80);
        job.getHealthReport().add(healthReport);
        HudsonServerBehaviourTest.assertEquals((int)80, (int)behaviour.parseJob(job).getHealth());
    }

    public void testParseJobNoColor() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob job = new HudsonModelJob();
        job.setUrl(String.valueOf(behaviour.getLocation().getUrl()) + "/job/test-job");
        IBuildPlan buildPlan = behaviour.parseJob(job);
        HudsonServerBehaviourTest.assertNull((Object)buildPlan.getState());
        HudsonServerBehaviourTest.assertNull((Object)buildPlan.getStatus());
    }

    public void testParseJobRunningColor() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob job = new HudsonModelJob();
        job.setUrl(String.valueOf(behaviour.getLocation().getUrl()) + "/job/test-job");
        for (HudsonModelBallColor color : this.getRunningColors()) {
            job.setColor(color);
            IBuildPlan buildPlan = behaviour.parseJob(job);
            HudsonServerBehaviourTest.assertEquals((Object)BuildState.RUNNING, (Object)buildPlan.getState());
        }
    }

    public void testParseJobStoppedColor() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob job = new HudsonModelJob();
        job.setUrl(String.valueOf(behaviour.getLocation().getUrl()) + "/job/test-job");
        for (HudsonModelBallColor color : this.getStoppedColors()) {
            job.setColor(color);
            IBuildPlan buildPlan = behaviour.parseJob(job);
            HudsonServerBehaviourTest.assertEquals((Object)BuildState.STOPPED, (Object)buildPlan.getState());
        }
    }

    public void testParseJobNestedJob() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob nestedJob = new HudsonModelJob();
        String nestedJobUrl = String.valueOf(baseUrl) + "/test-folder/job/test-nested-one/";
        nestedJob.setName("test-nested-one");
        nestedJob.setUrl(nestedJobUrl);
        IBuildPlan buildPlan = behaviour.parseJob(nestedJob);
        Assert.assertEquals((Object)nestedJobUrl, (Object)buildPlan.getId());
    }

    public void testParseJobTopLevelJob() throws Exception {
        RepositoryLocation repositoryLocation = new RepositoryLocation();
        String baseUrl = "http://test.org/jenkins/";
        repositoryLocation.setUrl(baseUrl);
        HudsonServerBehaviour behaviour = new HudsonServerBehaviour(repositoryLocation, new HudsonConfigurationCache());
        HudsonModelJob topLevelJob = new HudsonModelJob();
        String jobName = "test-succeeding";
        topLevelJob.setName(jobName);
        topLevelJob.setUrl(String.valueOf(baseUrl) + "job/test-succeeding/");
        IBuildPlan buildPlan = behaviour.parseJob(topLevelJob);
        Assert.assertEquals((Object)jobName, (Object)buildPlan.getId());
    }

    private Set<HudsonModelBallColor> getRunningColors() {
        HashSet<HudsonModelBallColor> result = new HashSet<HudsonModelBallColor>();
        HudsonModelBallColor[] hudsonModelBallColorArray = HudsonModelBallColor.values();
        int n = hudsonModelBallColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            HudsonModelBallColor color = hudsonModelBallColorArray[n2];
            if (color.value().endsWith("_anime")) {
                result.add(color);
            }
            ++n2;
        }
        return result;
    }

    private Set<HudsonModelBallColor> getStoppedColors() {
        HashSet<HudsonModelBallColor> result = new HashSet<HudsonModelBallColor>();
        HudsonModelBallColor[] hudsonModelBallColorArray = HudsonModelBallColor.values();
        int n = hudsonModelBallColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            HudsonModelBallColor color = hudsonModelBallColorArray[n2];
            if (!color.value().endsWith("_anime")) {
                result.add(color);
            }
            ++n2;
        }
        return result;
    }
}

