/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.core;

import junit.framework.TestCase;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.internal.hudson.core.HudsonConnector;

public class HudsonConnectorTest
extends TestCase {
    public void testBuildElementFromUrlJobUrl() throws Exception {
        IBuildServer server = BuildFactory.eINSTANCE.createBuildServer();
        server.setUrl("http://server/");
        HudsonConnector connector = new HudsonConnector();
        IBuildElement element = connector.getBuildElementFromUrl(server, "http://server/job/my-plan/3/");
        HudsonConnectorTest.assertNotNull((Object)element);
        HudsonConnectorTest.assertTrue((String)("Expected IBuild, got " + element.getClass()), (boolean)(element instanceof IBuild));
        IBuild build = (IBuild)element;
        HudsonConnectorTest.assertEquals((String)"3", (String)build.getId());
        HudsonConnectorTest.assertEquals((String)"my-plan", (String)build.getPlan().getId());
        HudsonConnectorTest.assertEquals((String)"http://server/job/my-plan/3/", (String)build.getUrl());
        HudsonConnectorTest.assertEquals((String)"http://server/job/my-plan/", (String)build.getPlan().getUrl());
    }

    public void testBuildElementFromUrlViewsUrl() throws Exception {
        IBuildServer server = BuildFactory.eINSTANCE.createBuildServer();
        server.setUrl("http://server/");
        HudsonConnector connector = new HudsonConnector();
        IBuildElement element = connector.getBuildElementFromUrl(server, "http://server/me/my-view/All/job/my-plan/3/");
        HudsonConnectorTest.assertNotNull((Object)element);
        HudsonConnectorTest.assertTrue((String)("Expected IBuild, got " + element.getClass()), (boolean)(element instanceof IBuild));
        IBuild build = (IBuild)element;
        HudsonConnectorTest.assertEquals((String)"3", (String)build.getId());
        HudsonConnectorTest.assertEquals((String)"my-plan", (String)build.getPlan().getId());
        HudsonConnectorTest.assertEquals((String)"http://server/me/my-view/All/job/my-plan/3/", (String)build.getUrl());
        HudsonConnectorTest.assertEquals((String)"http://server/me/my-view/All/job/my-plan/", (String)build.getPlan().getUrl());
    }

    public void testBuildElementFromUrlUserUrl() throws Exception {
        IBuildServer server = BuildFactory.eINSTANCE.createBuildServer();
        server.setUrl("http://server/");
        HudsonConnector connector = new HudsonConnector();
        IBuildElement element = connector.getBuildElementFromUrl(server, "http://server/user/myid/");
        HudsonConnectorTest.assertNull((Object)element);
    }

    public void testBuildElementFromUrlNotMatching() throws Exception {
        IBuildServer server = BuildFactory.eINSTANCE.createBuildServer();
        server.setUrl("http://server/");
        HudsonConnector connector = new HudsonConnector();
        IBuildElement element = connector.getBuildElementFromUrl(server, "http://server2/job/my-plan/3/");
        HudsonConnectorTest.assertNull((Object)element);
    }
}

