/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.hudson.tests.support.HudsonFixture;
import org.eclipse.mylyn.hudson.tests.support.HudsonHarness;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonException;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonUrlUtil;
import org.eclipse.mylyn.internal.hudson.core.client.RestfulHudsonClient;
import org.junit.Assert;

public class HudsonUrlUtilTest
extends TestCase {
    private HudsonUrlUtil hudsonUrlUtil;
    private HudsonHarness harness;
    private RepositoryLocation repositoryLocation;

    protected void setUp() throws Exception {
        this.harness = HudsonFixture.current().createHarness();
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        this.repositoryLocation = client.getLocation();
        this.hudsonUrlUtil = new HudsonUrlUtil(this.repositoryLocation);
    }

    public void testBaseUrl() {
        Assert.assertEquals((Object)this.repositoryLocation.getUrl(), (Object)this.hudsonUrlUtil.baseUrl());
    }

    public void testAssembleJobUrl() throws HudsonException {
        String jobName = this.harness.getPlanNestedTwo();
        String folderUrl = this.repositoryLocation.getUrl();
        String expectedJobUrl = String.valueOf(folderUrl) + "job/" + jobName + "/";
        Assert.assertEquals((Object)expectedJobUrl, (Object)this.hudsonUrlUtil.assembleJobUrl(jobName, folderUrl));
    }

    public void testAssembleJobUrlWithWhitespace() throws HudsonException, URISyntaxException {
        String jobName = this.harness.getPlanWhitespace();
        String folderUrl = this.repositoryLocation.getUrl();
        String encodedJobName = new URI(null, jobName, null).toASCIIString();
        String expectedJobUrl = String.valueOf(folderUrl) + "job/" + encodedJobName + "/";
        Assert.assertEquals((Object)expectedJobUrl, (Object)this.hudsonUrlUtil.assembleJobUrl(jobName, folderUrl));
    }

    public void testGroupJobNamesByFolderUrlWithoutJobUrls() throws HudsonException {
        Map jobNamesByFolderUrl = this.hudsonUrlUtil.groupJobNamesByFolderUrl(new ArrayList());
        Assert.assertNotNull((Object)jobNamesByFolderUrl);
        Assert.assertTrue((boolean)jobNamesByFolderUrl.isEmpty());
    }

    public void testGroupJobNameByFolderUrlWithJobUrlIds() throws HudsonException {
        String baseUrl = this.repositoryLocation.getUrl();
        String folderUrl = String.valueOf(baseUrl) + "job/test-folder/";
        String subFolderUrl = String.valueOf(folderUrl) + "job/test-sub-folder/";
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(String.valueOf(baseUrl) + "job/test-succeeding/");
        jobIds.add(String.valueOf(baseUrl) + "job/test-white%20space/");
        jobIds.add(String.valueOf(folderUrl) + "job/test-nested-one/");
        jobIds.add(String.valueOf(subFolderUrl) + "job/test-nested-two/");
        Map jobNamesByFolderUrl = this.hudsonUrlUtil.groupJobNamesByFolderUrl(jobIds);
        Assert.assertNotNull((Object)jobNamesByFolderUrl);
        Assert.assertEquals((long)3L, (long)jobNamesByFolderUrl.keySet().size());
        Assert.assertTrue((boolean)jobNamesByFolderUrl.containsKey(baseUrl));
        List baseUrlJobs = (List)jobNamesByFolderUrl.get(baseUrl);
        Assert.assertNotNull((Object)baseUrlJobs);
        Assert.assertTrue((boolean)baseUrlJobs.contains("test-succeeding"));
        Assert.assertTrue((boolean)baseUrlJobs.contains("test-white space"));
        Assert.assertTrue((boolean)jobNamesByFolderUrl.containsKey(baseUrl));
        List folderUrlJobs = (List)jobNamesByFolderUrl.get(folderUrl);
        Assert.assertNotNull((Object)folderUrlJobs);
        Assert.assertTrue((boolean)folderUrlJobs.contains("test-nested-one"));
        Assert.assertTrue((boolean)jobNamesByFolderUrl.containsKey(baseUrl));
        List subFolderUrlJobs = (List)jobNamesByFolderUrl.get(subFolderUrl);
        Assert.assertNotNull((Object)subFolderUrlJobs);
        Assert.assertTrue((boolean)subFolderUrlJobs.contains("test-nested-two"));
    }

    public void testGroupJobNameByFolderUrlWithJobNameIds() throws HudsonException {
        String baseUrl = this.repositoryLocation.getUrl();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(this.harness.getPlanGit());
        jobIds.add(this.harness.getPlanWhitespace());
        Map jobNamesByFolderUrl = this.hudsonUrlUtil.groupJobNamesByFolderUrl(jobIds);
        Assert.assertNotNull((Object)jobNamesByFolderUrl);
        Assert.assertEquals((long)1L, (long)jobNamesByFolderUrl.keySet().size());
        List baseUrlJobs = (List)jobNamesByFolderUrl.get(baseUrl);
        Assert.assertNotNull((Object)baseUrlJobs);
        Assert.assertTrue((boolean)baseUrlJobs.contains(this.harness.getPlanGit()));
        Assert.assertTrue((boolean)baseUrlJobs.contains(this.harness.getPlanWhitespace()));
    }

    public void testGroupJobNameByFolderUrlWithJobNameIdsAndJobUrlIds() throws HudsonException {
        String baseUrl = this.repositoryLocation.getUrl();
        String folderUrl = String.valueOf(baseUrl) + "job/test-folder/";
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(this.harness.getPlanGit());
        jobIds.add(this.harness.getPlanWhitespace());
        jobIds.add(String.valueOf(baseUrl) + "job/test-succeeding/");
        jobIds.add(String.valueOf(folderUrl) + "job/test-nested-one/");
        Map jobNamesByFolderUrl = this.hudsonUrlUtil.groupJobNamesByFolderUrl(jobIds);
        Assert.assertNotNull((Object)jobNamesByFolderUrl);
        Assert.assertEquals((long)2L, (long)jobNamesByFolderUrl.keySet().size());
        List baseUrlJobs = (List)jobNamesByFolderUrl.get(baseUrl);
        Assert.assertNotNull((Object)baseUrlJobs);
        Assert.assertTrue((boolean)baseUrlJobs.contains(this.harness.getPlanGit()));
        Assert.assertTrue((boolean)baseUrlJobs.contains(this.harness.getPlanWhitespace()));
        Assert.assertTrue((boolean)baseUrlJobs.contains("test-succeeding"));
        List folderUrlJobs = (List)jobNamesByFolderUrl.get(folderUrl);
        Assert.assertNotNull((Object)folderUrlJobs);
        Assert.assertTrue((boolean)folderUrlJobs.contains("test-nested-one"));
    }

    public void testGetJobUrlFromJobIdWithJobName() throws HudsonException {
        String jobId = this.harness.getPlanGit();
        String expectedJobUrl = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + jobId + "/";
        String jobUrl = this.hudsonUrlUtil.getJobUrlFromJobId(jobId);
        Assert.assertEquals((Object)expectedJobUrl, (Object)jobUrl);
    }

    public void testGetJobUrlFromJobIdWithJobUrl() throws HudsonException {
        String jobId = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanSucceeding() + "/";
        String jobUrl = this.hudsonUrlUtil.getJobUrlFromJobId(jobId);
        Assert.assertEquals((Object)jobId, (Object)jobUrl);
    }

    public void testGetJobUrlFromJobIdWithNestedJobUrl() throws HudsonException {
        String jobId = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanFolder() + "/job/" + this.harness.getPlanNestedOne() + "/";
        String jobUrl = this.hudsonUrlUtil.getJobUrlFromJobId(jobId);
        Assert.assertEquals((Object)jobId, (Object)jobUrl);
    }

    public void testIsNestedJobWithNestedJob() {
        String nestedJobId = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanFolder() + "/job/" + this.harness.getPlanNestedOne() + "/";
        Assert.assertTrue((boolean)this.hudsonUrlUtil.isNestedJob(nestedJobId));
    }

    public void testIsNestedJobWithTopLevelJob() {
        String topLevelJobId = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanSucceeding() + "/";
        Assert.assertFalse((boolean)this.hudsonUrlUtil.isNestedJob(topLevelJobId));
    }

    public void testGetDisplayNameWithTopLevelJob() throws HudsonException {
        String nestedJobUrl = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanSucceeding() + "/";
        String expectedDisplayName = this.harness.getPlanSucceeding();
        Assert.assertEquals((Object)expectedDisplayName, (Object)this.hudsonUrlUtil.getDisplayName(nestedJobUrl));
    }

    public void testGetDisplayNameWithNestedJob() throws HudsonException {
        String nestedJobUrl = String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanFolder() + "/job/" + this.harness.getPlanNestedOne() + "/";
        String expectedDisplayName = String.valueOf(this.harness.getPlanFolder()) + "/" + this.harness.getPlanNestedOne();
        Assert.assertEquals((Object)expectedDisplayName, (Object)this.hudsonUrlUtil.getDisplayName(nestedJobUrl));
    }

    public void testGetDisplayNameWithJobNamedJob() throws HudsonException {
        String nestedJobUrl = String.valueOf(this.repositoryLocation.getUrl()) + "job/job/";
        String expectedDisplayName = "job";
        Assert.assertEquals((Object)expectedDisplayName, (Object)this.hudsonUrlUtil.getDisplayName(nestedJobUrl));
    }

    public void testGetDisplayNameWithFolderAndJobNamedJob() throws HudsonException {
        String nestedJobUrl = String.valueOf(this.repositoryLocation.getUrl()) + "job/job/job/job/";
        String expectedDisplayName = "job/job";
        Assert.assertEquals((Object)expectedDisplayName, (Object)this.hudsonUrlUtil.getDisplayName(nestedJobUrl));
    }

    public void testGetDisplayNameWithWhitespace() throws URISyntaxException, HudsonException {
        String jobUrl = new URI(null, String.valueOf(this.repositoryLocation.getUrl()) + "job/" + this.harness.getPlanWhitespace() + "/", null).toASCIIString();
        String expectedDisplayName = this.harness.getPlanWhitespace();
        Assert.assertEquals((Object)expectedDisplayName, (Object)this.hudsonUrlUtil.getDisplayName(jobUrl));
    }
}

