/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.client;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonUrl;

public class HudsonUrlTest
extends TestCase {
    public void testQuotes() throws Exception {
        HudsonUrlTest.assertEquals((String)HudsonUrlTest.getExpectedUrl("%27example%27"), (String)this.createHudsonUrl("example"));
        HudsonUrlTest.assertEquals((String)HudsonUrlTest.getExpectedUrl("%22exampleWithSingle%27Quote%22"), (String)this.createHudsonUrl("exampleWithSingle'Quote"));
        HudsonUrlTest.assertEquals((String)HudsonUrlTest.getExpectedUrl("%27exampleWithDouble%22Quote%27"), (String)this.createHudsonUrl("exampleWithDouble\"Quote"));
        try {
            this.createHudsonUrl("exampleWithSingle'AndDouble\"Quote");
            HudsonUrlTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private String createHudsonUrl(String buildName) throws UnsupportedEncodingException {
        return HudsonUrl.create((String)"http://hudson.com").depth(1).include("/hudson/job").match("name", Collections.singletonList(buildName)).exclude("/hudson/job/build").toUrl();
    }

    private static String getExpectedUrl(String quotedName) {
        return "http://hudson.com/api/xml?wrapper=hudson&depth=1&xpath=/hudson/job%5Bname%3D" + quotedName + "%5D&exclude=/hudson/job/build";
    }
}

