/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests.client;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.hudson.tests.support.HudsonFixture;
import org.eclipse.mylyn.hudson.tests.support.HudsonHarness;
import org.eclipse.mylyn.hudson.tests.support.HudsonTestUtil;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonException;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonResourceNotFoundException;
import org.eclipse.mylyn.internal.hudson.core.client.HudsonServerInfo;
import org.eclipse.mylyn.internal.hudson.core.client.RestfulHudsonClient;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBallColor;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBuild;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRun;

public class HudsonClientTest
extends TestCase {
    private HudsonHarness harness;

    protected void setUp() throws Exception {
        this.harness = HudsonFixture.current().createHarness();
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testValidateValidUrl() throws Exception {
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        HudsonServerInfo info = client.validate(null);
        HudsonClientTest.assertEquals((Object)this.harness.getFixture().getType(), (Object)info.getType());
    }

    public void testValidateValidUrlAuthenticate() throws Exception {
        if (!HudsonFixture.current().canAuthenticate()) {
            return;
        }
        RestfulHudsonClient client = this.harness.connect();
        HudsonServerInfo info = client.validate(null);
        HudsonClientTest.assertEquals((Object)this.harness.getFixture().getType(), (Object)info.getType());
    }

    public void testValidateExpiredCookie() throws Exception {
        if (!HudsonFixture.current().canAuthenticate()) {
            return;
        }
        RestfulHudsonClient client = this.harness.connect();
        client.validate(null);
        client.reset();
        HudsonServerInfo info = client.validate(null);
        HudsonClientTest.assertEquals((Object)this.harness.getFixture().getType(), (Object)info.getType());
    }

    public void testGetJobs() throws Exception {
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        this.harness.ensureHasRun(this.harness.getPlanFailing());
        this.harness.ensureHasRun(this.harness.getPlanSucceeding());
        List jobs = client.getJobs(null, null);
        HudsonTestUtil.assertContains(jobs, this.harness.getPlanFailing());
        HudsonTestUtil.assertContains(jobs, this.harness.getPlanSucceeding());
        HudsonTestUtil.assertHealthReport(jobs);
    }

    public void testGetManyJobs() throws Exception {
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        this.harness.ensureHasRun(this.harness.getPlanSucceeding());
        List<String> jobIDs = Collections.nCopies(1000, this.harness.getPlanSucceeding());
        List jobs = client.getJobs(jobIDs, null);
        HudsonTestUtil.assertContains(jobs, this.harness.getPlanSucceeding());
        HudsonTestUtil.assertHealthReport(jobs);
    }

    public void testGetNestedJobs() throws Exception {
        if (this.harness.getFixture().getType().equals((Object)HudsonServerInfo.Type.HUDSON)) {
            return;
        }
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        List jobs = client.getJobs(null, null);
        HudsonTestUtil.assertContainsNot(jobs, this.harness.getPlanFolder());
        HudsonTestUtil.assertContains(jobs, this.harness.getPlanNestedOne());
        HudsonTestUtil.assertContainsNot(jobs, this.harness.getPlanSubFolder());
        HudsonTestUtil.assertContains(jobs, this.harness.getPlanNestedTwo());
    }

    public void testGetJobsWithWhitespaces() throws Exception {
        this.harness.ensureHasRun(this.harness.getPlanWhitespace());
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        List jobs = client.getJobs(Collections.singletonList(this.harness.getPlanWhitespace()), null);
        HudsonClientTest.assertEquals((int)1, (int)jobs.size());
        HudsonModelJob job = (HudsonModelJob)jobs.get(0);
        HudsonClientTest.assertEquals((Object)this.harness.getSuccessColor(), (Object)job.getColor());
        HudsonModelBuild build = client.getBuild(job, job.getLastBuild(), null);
        HudsonClientTest.assertNotNull((Object)build);
    }

    public void testGetJobDisabled() throws Exception {
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        List jobs = client.getJobs(Collections.singletonList(this.harness.getPlanDisabled()), null);
        HudsonClientTest.assertEquals((int)1, (int)jobs.size());
        HudsonModelJob job = (HudsonModelJob)jobs.get(0);
        HudsonClientTest.assertEquals((Object)HudsonModelBallColor.DISABLED, (Object)job.getColor());
        try {
            HudsonModelBuild build = client.getBuild(job, (HudsonModelRun)RestfulHudsonClient.BuildId.LAST.getBuild(), null);
            HudsonClientTest.fail((String)("Expected HudsonResourceNotFoundException, since " + this.harness.getPlanDisabled() + " was never built, got: " + build));
        }
        catch (HudsonResourceNotFoundException hudsonResourceNotFoundException) {
            // empty catch block
        }
    }

    public void testGetJobGit() throws Exception {
        this.harness.ensureHasRun(this.harness.getPlanGit());
        RestfulHudsonClient client = this.harness.connect(CommonTestUtil.PrivilegeLevel.ANONYMOUS);
        List jobs = client.getJobs(Collections.singletonList(this.harness.getPlanGit()), null);
        HudsonClientTest.assertEquals((int)1, (int)jobs.size());
        HudsonModelJob job = (HudsonModelJob)jobs.get(0);
        HudsonModelBuild build = client.getBuild(job, (HudsonModelRun)RestfulHudsonClient.BuildId.LAST.getBuild(), null);
        HudsonClientTest.assertNotNull((Object)build.getAction());
    }

    public void testRunBuildFailing() throws Exception {
        if (!HudsonFixture.current().canAuthenticate()) {
            return;
        }
        final String jobName = this.harness.getPlanFailing();
        RestfulHudsonClient client = this.harness.connect();
        this.ensureHasRunOnce(client, jobName, HudsonModelBallColor.RED);
        this.runBuild(client, jobName);
        HudsonTestUtil.poll(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                HudsonClientTest.assertEquals((Object)HudsonModelBallColor.RED_ANIME, (Object)HudsonClientTest.this.harness.getJob(jobName).getColor());
                return null;
            }
        });
    }

    private void ensureHasRunOnce(RestfulHudsonClient client, final String jobName, final HudsonModelBallColor expectedColor) throws Exception {
        if (!expectedColor.equals((Object)this.harness.getJob(jobName).getColor())) {
            client.runBuild(this.harness.getJob(jobName), null, null);
            HudsonTestUtil.poll(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    HudsonClientTest.assertEquals((Object)expectedColor, (Object)HudsonClientTest.this.harness.getJob(jobName).getColor());
                    return null;
                }
            });
        }
    }

    public void testRunBuildSucceeding() throws Exception {
        if (!HudsonFixture.current().canAuthenticate()) {
            return;
        }
        final String jobName = this.harness.getPlanSucceeding();
        RestfulHudsonClient client = this.harness.connect();
        this.ensureHasRunOnce(client, jobName, this.harness.getSuccessColor());
        this.runBuild(client, jobName);
        HudsonTestUtil.poll(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                HudsonClientTest.assertEquals((Object)HudsonClientTest.this.harness.getSuccessAnimeColor(), (Object)HudsonClientTest.this.harness.getJob(jobName).getColor());
                return null;
            }
        });
    }

    private void runBuild(RestfulHudsonClient client, String jobName) throws HudsonException {
        block2: {
            try {
                client.runBuild(this.harness.getJob(jobName), null, null);
            }
            catch (HudsonException e) {
                if (!e.getMessage().contains("Bad Gateway")) break block2;
                client.runBuild(this.harness.getJob(jobName), null, null);
            }
        }
    }

    public void testAbortBuild() throws Exception {
        if (!HudsonFixture.current().canAuthenticate()) {
            return;
        }
        final String jobName = this.harness.getPlanSucceeding();
        RestfulHudsonClient client = this.harness.connect();
        this.runBuild(client, jobName);
        HudsonTestUtil.poll(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                HudsonModelRun run = HudsonClientTest.this.harness.getJob(jobName).getLastBuild();
                HudsonModelBuild build = HudsonClientTest.this.harness.getBuild(jobName, run.getNumber());
                HudsonClientTest.assertTrue((boolean)build.isBuilding());
                return null;
            }
        });
        this.abortBuild(client, jobName);
        HudsonTestUtil.poll(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                HudsonClientTest.assertEquals((Object)HudsonClientTest.this.harness.getAbortedColor(), (Object)HudsonClientTest.this.harness.getJob(jobName).getColor());
                return null;
            }
        });
    }

    private void abortBuild(RestfulHudsonClient client, String jobName) throws HudsonException {
        block2: {
            HudsonModelJob job = this.harness.getJob(jobName);
            HudsonModelBuild build = new HudsonModelBuild();
            build.setNumber(job.getLastBuild().getNumber());
            try {
                client.abortBuild(job, build, null);
            }
            catch (HudsonException e) {
                if (!e.getMessage().contains("Bad Gateway")) break block2;
                client.abortBuild(job, build, null);
            }
        }
    }

    public void testRunNestedJob() throws Exception {
        if (!HudsonFixture.current().canAuthenticate() || this.harness.getFixture().getType().equals((Object)HudsonServerInfo.Type.HUDSON)) {
            return;
        }
        final String jobName = this.harness.getPlanNestedOne();
        RestfulHudsonClient client = this.harness.connect();
        this.ensureHasRunOnce(client, jobName, this.harness.getSuccessAnimeColor());
        client.runBuild(this.harness.getJob(jobName), null, null);
        HudsonTestUtil.poll(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                HudsonClientTest.assertEquals((Object)HudsonClientTest.this.harness.getSuccessAnimeColor(), (Object)HudsonClientTest.this.harness.getJob(jobName).getColor());
                return null;
            }
        });
    }
}

