/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.hudson.tests;

import java.io.PrintStream;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.ManagedSuite;
import org.eclipse.mylyn.commons.sdk.util.ManagedTestSuite;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.hudson.tests.client.HudsonClientTest;
import org.eclipse.mylyn.hudson.tests.client.HudsonUrlTest;
import org.eclipse.mylyn.hudson.tests.client.HudsonValidationTest;
import org.eclipse.mylyn.hudson.tests.core.HudsonConnectorTest;
import org.eclipse.mylyn.hudson.tests.core.HudsonServerBehaviourTest;
import org.eclipse.mylyn.hudson.tests.integration.HudsonIntegrationTest;
import org.eclipse.mylyn.hudson.tests.support.HudsonFixture;

public class AllHudsonTests {
    public static Test suite() {
        if (CommonTestUtil.fixProxyConfiguration()) {
            CommonTestUtil.dumpSystemInfo((PrintStream)System.err);
        }
        TestConfiguration testConfiguration = ManagedSuite.getTestConfigurationOrCreateDefault();
        ManagedTestSuite suite = new ManagedTestSuite(AllHudsonTests.class.getName());
        AllHudsonTests.addTests((TestSuite)suite, testConfiguration);
        return suite;
    }

    public static Test suite(TestConfiguration configuration) {
        TestSuite suite = new TestSuite(AllHudsonTests.class.getName());
        AllHudsonTests.addTests(suite, configuration);
        return suite;
    }

    private static void addTests(TestSuite suite, TestConfiguration configuration) {
        suite.addTestSuite(HudsonConnectorTest.class);
        suite.addTestSuite(HudsonServerBehaviourTest.class);
        suite.addTestSuite(HudsonUrlTest.class);
        if (!configuration.isLocalOnly()) {
            ArrayList fixtures;
            suite.addTestSuite(HudsonValidationTest.class);
            try {
                fixtures = configuration.discover(HudsonFixture.class, "hudson");
            }
            catch (RuntimeException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.hudson.core", "No hudson fixtures found, will look for jenkins fixtures", (Throwable)e));
                fixtures = new ArrayList();
            }
            fixtures.addAll(configuration.discover(HudsonFixture.class, "jenkins"));
            for (HudsonFixture fixture : fixtures) {
                if (fixture.isExcluded() || fixture.isUseCertificateAuthentication() && CommonTestUtil.isCertificateAuthBroken()) continue;
                fixture.createSuite(suite);
                fixture.add(HudsonClientTest.class);
                if (!fixture.isUseCertificateAuthentication()) {
                    fixture.add(HudsonIntegrationTest.class);
                }
                fixture.done();
            }
        }
    }
}

