/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.common.collect.Sets;
import java.util.SortedSet;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.mylyn.internal.gerrit.ui.operations.BranchProposalProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BranchProposalProviderTest {
    private SortedSet<String> proposals;
    private BranchProposalProvider provider;

    @Before
    public void setUp() {
        this.setUpProvider("a", "b", "c");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetProposalsNullContents() {
        this.provider.getProposals(null, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetProposalsNegativeCursorPosition() {
        this.provider.getProposals("", -1);
    }

    @Test
    public void testGetAllProposalsWhenContentsEmpty() {
        IContentProposal[] branches = this.provider.getProposals("", 0);
        Assert.assertEquals((long)3L, (long)branches.length);
        Assert.assertEquals((Object)"a", (Object)branches[0].getContent());
        Assert.assertEquals((Object)"b", (Object)branches[1].getContent());
        Assert.assertEquals((Object)"c", (Object)branches[2].getContent());
    }

    @Test
    public void testGetAllProposalsInNaturalOrdering() {
        this.setUpProvider("c", "b", "a");
        IContentProposal[] branches = this.provider.getProposals("", 0);
        Assert.assertEquals((long)3L, (long)branches.length);
        Assert.assertEquals((Object)"a", (Object)branches[0].getContent());
        Assert.assertEquals((Object)"b", (Object)branches[1].getContent());
        Assert.assertEquals((Object)"c", (Object)branches[2].getContent());
    }

    @Test
    public void testGetCorrectProposal() {
        IContentProposal[] branches = this.provider.getProposals("a", 0);
        Assert.assertEquals((long)1L, (long)branches.length);
        Assert.assertEquals((Object)"a", (Object)branches[0].getContent());
    }

    @Test
    public void testGetMatchingProposals() {
        this.setUpProvider("ac", "ba", "cb");
        IContentProposal[] branches = this.provider.getProposals("a", 0);
        Assert.assertEquals((long)2L, (long)branches.length);
        Assert.assertEquals((Object)"ac", (Object)branches[0].getContent());
        Assert.assertEquals((Object)"ba", (Object)branches[1].getContent());
    }

    @Test
    public void testCursorInCorrectPosition() {
        this.setUpProvider("a", "ab", "abc");
        IContentProposal[] branches = this.provider.getProposals("a", 0);
        Assert.assertEquals((long)3L, (long)branches.length);
        Assert.assertEquals((Object)"a", (Object)branches[0].getContent());
        Assert.assertEquals((long)1L, (long)branches[0].getCursorPosition());
        Assert.assertEquals((Object)"ab", (Object)branches[1].getContent());
        Assert.assertEquals((long)2L, (long)branches[1].getCursorPosition());
        Assert.assertEquals((Object)"abc", (Object)branches[2].getContent());
        Assert.assertEquals((long)3L, (long)branches[2].getCursorPosition());
    }

    private void setUpProvider(String ... branchNames) {
        this.proposals = Sets.newTreeSet();
        String[] stringArray = branchNames;
        int n = branchNames.length;
        int n2 = 0;
        while (n2 < n) {
            String branch = stringArray[n2];
            this.proposals.add(branch);
            ++n2;
        }
        this.provider = new BranchProposalProvider(this.proposals);
    }
}

