/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.mylyn.internal.gerrit.ui.operations.AddReviewersDialog;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddReviewersDialogTest {
    private Shell shell;
    private AddReviewersDialog dialog;

    @Before
    public void setUp() {
        this.shell = new Shell();
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "url");
        TasksUi.getRepositoryManager().addRepository(repository);
        ITask task = TasksUi.getRepositoryModel().createTask(repository, "1");
        this.dialog = new AddReviewersDialog(this.shell, task);
        this.dialog.create();
    }

    @After
    public void tearDown() {
        this.shell.dispose();
    }

    @Test
    public void testGetReviewers() {
        this.dialog.setText("a, b, c");
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)this.dialog.getReviewers());
    }

    @Test
    public void testGetReviewersTwo() {
        this.dialog.setText("b,a");
        Assert.assertEquals(Arrays.asList("b", "a"), (Object)this.dialog.getReviewers());
    }

    @Test
    public void testGetReviewersWithComma() {
        this.dialog.setText("a,b,");
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)this.dialog.getReviewers());
    }

    @Test
    public void testGetReviewersEmpty() {
        this.dialog.setText("");
        Assert.assertEquals(Collections.emptyList(), (Object)this.dialog.getReviewers());
    }

    @Test
    public void testGetReviewersBlank() {
        this.dialog.setText("   ");
        Assert.assertEquals(Collections.emptyList(), (Object)this.dialog.getReviewers());
    }

    @Test
    public void testGetReviewersCommasOnly() {
        this.dialog.setText(",,,");
        Assert.assertEquals(Collections.emptyList(), (Object)this.dialog.getReviewers());
    }

    @Test
    public void testGetReviewersOne() {
        this.dialog.setText("  one reviewer  ");
        Assert.assertEquals(Arrays.asList("one reviewer"), (Object)this.dialog.getReviewers());
    }
}

