/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GerritTaskEditorTest {
    private ITask task;
    private TasksUiLogListener listener;

    @Before
    public void setUp() {
        TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "url");
        TasksUi.getRepositoryManager().addRepository(repository);
        this.task = TasksUi.getRepositoryModel().createTask(repository, "1");
        this.addLogListener();
    }

    @After
    public void tearDown() {
        this.removeLogListener();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    @Test
    public void testOpenEditor() {
        TasksUiUtil.openTask((ITask)this.task);
        for (IStatus status : this.listener.getStatuses()) {
            Assert.assertFalse((boolean)status.getMessage().contains("Could not create editor via factory"));
        }
    }

    private void addLogListener() {
        ILog log;
        if (InternalPlatform.getDefault() != null && PlatformActivator.getContext() != null && (log = InternalPlatform.getDefault().getLog(PlatformActivator.getContext().getBundle())) != null) {
            this.listener = new TasksUiLogListener();
            log.addLogListener((ILogListener)this.listener);
        }
    }

    private void removeLogListener() {
        ILog log;
        if (this.listener != null && InternalPlatform.getDefault() != null && PlatformActivator.getContext() != null && (log = InternalPlatform.getDefault().getLog(PlatformActivator.getContext().getBundle())) != null) {
            log.removeLogListener((ILogListener)this.listener);
        }
        this.listener = null;
    }

    private static class TasksUiLogListener
    implements ILogListener {
        List<IStatus> statuses = new ArrayList<IStatus>();

        private TasksUiLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            if ("org.eclipse.core.runtime".equals(plugin) && "org.eclipse.mylyn.tasks.ui".equals(status.getPlugin())) {
                this.statuses.add(status);
            }
        }

        private Collection<IStatus> getStatuses() {
            return Collections.unmodifiableList(this.statuses);
        }
    }
}

