/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.gerrit.core.GerritQueryResultSchema;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritReviewDetailSection;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritTaskEditorPage;
import org.eclipse.mylyn.internal.gerrit.ui.editor.PatchSetSection;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.editors.PersonAttributeEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorNewCommentPart;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.handlers.IHandlerService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;

public class GerritTaskEditorPageTest
extends TestCase {
    private GerritTaskEditorPage page;
    private ArrayList<TaskEditorPartDescriptor> descriptors;

    protected void setUp() throws Exception {
        this.page = new TestGerritTaskEditorPage();
        this.descriptors = new ArrayList(this.page.createPartDescriptors());
    }

    public void testCreatePartDescriptorsCustomOrder() {
        ImmutableList partClasses = ImmutableList.copyOf((Iterable)Iterables.transform(this.descriptors.subList(this.descriptors.size() - 4, this.descriptors.size()), (Function)new Function<TaskEditorPartDescriptor, Class<?>>(){

            public Class<?> apply(TaskEditorPartDescriptor o) {
                return o.createPart().getClass();
            }
        }));
        GerritTaskEditorPageTest.assertEquals((Object)ImmutableList.of(GerritReviewDetailSection.class, PatchSetSection.class, TaskEditorCommentPart.class, TaskEditorNewCommentPart.class), (Object)partClasses);
        List ids = Lists.transform(this.descriptors, (Function)new Function<TaskEditorPartDescriptor, String>(){

            public String apply(TaskEditorPartDescriptor o) {
                return o.getId();
            }
        });
        GerritTaskEditorPageTest.assertTrue((String)("Missing descriptors. Found " + ids), (this.descriptors.size() >= 7 ? 1 : 0) != 0);
    }

    public void testCreateAttributesSectionOverlayAttributes() {
        TaskEditorPartDescriptor descriptor = (TaskEditorPartDescriptor)this.findById(this.descriptors, "org.eclipse.mylyn.tasks.ui.editors.parts.attributes").get();
        AbstractTaskEditorPart part = descriptor.createPart();
        part.initialize((AbstractTaskEditorPage)this.page);
        Assert.assertThat((Object)part, (Matcher)Matchers.instanceOf(GerritTaskEditorPage.GerritAttributePart.class));
        GerritTaskEditorPageTest.assertEquals((String)"attributes", (String)descriptor.getPath());
        List overlayAttributes = ((GerritTaskEditorPage.GerritAttributePart)part).getOverlayAttributes();
        GerritTaskEditorPageTest.assertEquals((int)2, (int)overlayAttributes.size());
        GerritTaskEditorPageTest.assertEquals((String)GerritQueryResultSchema.getDefault().PROJECT.getKey(), (String)((TaskAttribute)overlayAttributes.get(0)).getId());
        GerritTaskEditorPageTest.assertEquals((String)GerritQueryResultSchema.getDefault().BRANCH.getKey(), (String)((TaskAttribute)overlayAttributes.get(1)).getId());
    }

    public void testRemoveUnneededSections() {
        Optional<TaskEditorPartDescriptor> descriptor = this.findByPath(this.descriptors, "actions");
        GerritTaskEditorPageTest.assertFalse((boolean)descriptor.isPresent());
        descriptor = this.findByPath(this.descriptors, "people");
        GerritTaskEditorPageTest.assertFalse((boolean)descriptor.isPresent());
    }

    private Optional<TaskEditorPartDescriptor> findByPath(ArrayList<TaskEditorPartDescriptor> descriptors, final String path) {
        return Iterables.tryFind(descriptors, (Predicate)new Predicate<TaskEditorPartDescriptor>(){

            public boolean apply(TaskEditorPartDescriptor descriptor) {
                return descriptor.getPath().equals(path);
            }
        });
    }

    private Optional<TaskEditorPartDescriptor> findById(ArrayList<TaskEditorPartDescriptor> descriptors, final String id) {
        return Iterables.tryFind(descriptors, (Predicate)new Predicate<TaskEditorPartDescriptor>(){

            public boolean apply(TaskEditorPartDescriptor descriptor) {
                return descriptor.getId().equals(id);
            }
        });
    }

    public void testCreatePersonAttribute() throws Exception {
        TaskAttribute assigneeAttribute = this.page.getModel().getTaskData().getRoot().createAttribute("task.common.user.assigned");
        assigneeAttribute.getMetaData().setReadOnly(true);
        PersonAttributeEditor editor = (PersonAttributeEditor)this.page.createAttributeEditorFactory().createEditor("person", assigneeAttribute);
        GerritTaskEditorPageTest.assertTrue((boolean)editor.isReadOnly());
        assigneeAttribute.setValue("joel.user");
        GerritTaskEditorPageTest.assertEquals((String)"joel.user", (String)editor.getValue());
        assigneeAttribute.putOption("joel.user", "Joel K. User");
        GerritTaskEditorPageTest.assertEquals((String)"Joel K. User", (String)editor.getValue());
        editor.setReadOnly(false);
        GerritTaskEditorPageTest.assertEquals((String)"joel.user", (String)editor.getValue());
    }

    private static class TestGerritTaskEditorPage
    extends GerritTaskEditorPage {
        private final TaskDataModel model = (TaskDataModel)Mockito.mock(TaskDataModel.class);

        public TestGerritTaskEditorPage() {
            super((TaskEditor)Mockito.mock(TaskEditor.class));
            TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "mock");
            TaskData taskData = new TaskData(new TaskAttributeMapper(repository), "org.eclipse.mylyn.gerrit", "mock", "mock");
            taskData.getRoot().createAttribute(GerritQueryResultSchema.getDefault().BRANCH.getKey());
            taskData.getRoot().createAttribute(GerritQueryResultSchema.getDefault().PROJECT.getKey());
            taskData.getRoot().createAttribute(GerritQueryResultSchema.getDefault().STATUS.getKey());
            Mockito.when((Object)this.model.getTaskData()).thenReturn((Object)taskData);
            Mockito.when((Object)this.model.getTaskRepository()).thenReturn((Object)repository);
            IEditorSite editorSite = (IEditorSite)Mockito.mock(IEditorSite.class);
            IHandlerService service = (IHandlerService)Mockito.mock(IHandlerService.class);
            Mockito.when((Object)((IHandlerService)editorSite.getService(IHandlerService.class))).thenReturn((Object)service);
            TaskEditorInput taskEditorInput = new TaskEditorInput(repository, (ITask)new TaskTask("org.eclipse.mylyn.gerrit", "mock", "mock"));
            Mockito.when((Object)this.getTaskEditor().getTaskEditorInput()).thenReturn((Object)taskEditorInput);
            this.init(editorSite, (IEditorInput)taskEditorInput);
        }

        protected TaskDataModel createModel(TaskEditorInput input) throws CoreException {
            return this.model;
        }

        public TaskDataModel getModel() {
            return this.model;
        }
    }
}

