/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.Arrays;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUrlHandler;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritTaskEditorPage;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Ignore
public class GerritUrlHandlerTest {
    private final TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://review.mylyn.org");
    private final GerritUrlHandler handler = new GerritUrlHandler();
    private IWorkbenchPage page;
    private String taskId;
    private int patchSetNumber;
    private String path;

    @Test
    public void testGetTaskId() {
        Assert.assertEquals((Object)"123", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/123"));
    }

    @Test
    public void testGetTaskIdTrailingSlashAfterId() {
        Assert.assertEquals((Object)"123", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/123/foo/bar"));
    }

    @Test
    public void testGetTaskIdInvalidId() {
        Assert.assertEquals(null, (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/ab123"));
    }

    @Test
    public void testGetTaskIdRepositoryMismatch() {
        Assert.assertEquals(null, (Object)this.handler.getTaskId(this.repository, "http://mylyn.org/reviews/123"));
    }

    @Test
    public void testGetTaskIdSubPath() {
        Assert.assertEquals((Object)"123", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/123"));
    }

    @Test
    public void testGetTaskIdTrailingSlash() {
        TaskRepository trailingSlashRepository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://review.mylyn.org/");
        Assert.assertEquals((Object)"123", (Object)this.handler.getTaskId(trailingSlashRepository, "http://review.mylyn.org/123"));
    }

    @Test
    public void testGetTaskIdAbsolute() {
        Assert.assertEquals((Object)"123", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/#/c/123"));
    }

    @Test
    public void testGetTaskIdLetters() {
        Assert.assertEquals(null, (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/#/c/abc/"));
    }

    @Test
    public void testGetTaskIdEmpty() {
        Assert.assertEquals(null, (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/#/c//"));
    }

    @Test
    public void testGetTaskIdAbsoluteTrailingSlash() {
        Assert.assertEquals((Object)"123", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/#/c/123/"));
    }

    @Test
    public void testGetTaskIdPatchSet() {
        Assert.assertEquals((Object)"4698", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/#/c/4698/5"));
    }

    @Test
    public void testGetTaskIdFile() {
        Assert.assertEquals((Object)"4698", (Object)this.handler.getTaskId(this.repository, "http://review.mylyn.org/#/c/4698/5/foo/bar"));
    }

    @Test
    public void testGetPatchSetNumberPatchSet() {
        String url = "http://review.mylyn.org/#/c/4698/5";
        this.taskId = this.handler.getTaskId(this.repository, url);
        Assert.assertEquals((long)5L, (long)this.handler.getPatchSetNumber(this.repository, url, this.taskId));
    }

    @Test
    public void testGetPatchSetNumberPatchSetTrailingSlash() {
        String url = "http://review.mylyn.org/#/c/4698/5/";
        this.taskId = this.handler.getTaskId(this.repository, url);
        Assert.assertEquals((long)5L, (long)this.handler.getPatchSetNumber(this.repository, url, this.taskId));
    }

    @Test
    public void testGetPatchSetNumberPatchSetFile() {
        String url = "http://review.mylyn.org/#/c/4698/5/foo/bar";
        this.taskId = this.handler.getTaskId(this.repository, url);
        Assert.assertEquals((long)5L, (long)this.handler.getPatchSetNumber(this.repository, url, this.taskId));
    }

    @Test
    public void testGetPatchSetNumberNoneSpecified() {
        String url = "http://review.mylyn.org/#/c/4698";
        this.taskId = this.handler.getTaskId(this.repository, url);
        Assert.assertEquals((long)-1L, (long)this.handler.getPatchSetNumber(this.repository, url, this.taskId));
    }

    @Test
    public void testGetPatchSetNumberNoneSpecifiedTrailingSlash() {
        String url = "http://review.mylyn.org/#/c/4698/";
        this.taskId = this.handler.getTaskId(this.repository, url);
        Assert.assertEquals((long)-1L, (long)this.handler.getPatchSetNumber(this.repository, url, this.taskId));
    }

    @Test
    public void testGetPatchSetNumberNoneSpecifiedNotAnInteger() {
        String url = "http://review.mylyn.org/#/c/A1";
        this.taskId = this.handler.getTaskId(this.repository, url);
        Assert.assertEquals((long)-1L, (long)this.handler.getPatchSetNumber(this.repository, url, this.taskId));
    }

    @Test
    public void testGetPathNoneSpecified() {
        this.assertPath(null, "http://review.mylyn.org/#/c/4698/5");
    }

    @Test
    public void testGetPathNoneSpecifiedTrailingSlash() {
        this.assertPath(null, "http://review.mylyn.org/#/c/4698/5/");
    }

    @Test
    public void testGetPathNoneSpecifiedInvalidPatchNumber() {
        this.assertPath(null, "http://review.mylyn.org/#/c/4698/-1abcd");
    }

    @Test
    public void testGetPathNoneSpecifiedInvalidPatchNumberTrailingSlash() {
        this.assertPath(null, "http://review.mylyn.org/#/c/4698/-1abcd/");
    }

    @Test
    public void testGetPath() {
        this.assertPath("foo/bar.java", "http://review.mylyn.org/#/c/4698/5/foo/bar.java");
    }

    @Test
    public void testGetPathWithTrailingSlash() {
        this.assertPath("foo/bar.java", "http://review.mylyn.org/#/c/4698/5/foo/bar.java/");
    }

    @Test
    public void testOpenUrlWithInvalidReview() throws Exception {
        String url = "http://review.mylyn.org/#/c/4698/1/foo/bar.java";
        GerritUrlHandler spy = this.setUpOpenUrlTests(url);
        ((GerritUrlHandler)Mockito.doReturn(null).when((Object)spy)).revealPatchSet((EditorHandle)ArgumentMatchers.any(EditorHandle.class), Integer.valueOf(ArgumentMatchers.anyInt()));
        spy.openUrl(this.page, url, 0);
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).revealPatchSet((EditorHandle)ArgumentMatchers.any(EditorHandle.class), Integer.valueOf(ArgumentMatchers.anyInt()));
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).getFileItem((IReview)ArgumentMatchers.any(IReview.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).openCompareEditor(null);
    }

    @Test
    public void testOpenUrlWithValidPathOpenReview() throws Exception {
        String url = "http://review.mylyn.org/#/c/4698/1/foo/bar.java";
        GerritUrlHandler spy = this.setUpOpenUrlTests(url);
        GerritTaskEditorPage page = (GerritTaskEditorPage)Mockito.mock(GerritTaskEditorPage.class);
        IReview review = this.createMockReview();
        Mockito.when((Object)page.getReview()).thenReturn((Object)review);
        ((GerritUrlHandler)Mockito.doReturn((Object)page).when((Object)spy)).revealPatchSet((EditorHandle)ArgumentMatchers.any(EditorHandle.class), Integer.valueOf(ArgumentMatchers.anyInt()));
        this.openReviewTest(spy, url);
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getFileItem(review, 1, "foo/bar.java");
        Assert.assertEquals((Object)this.path, (Object)spy.getFileItem(review, this.patchSetNumber, this.path).getName());
    }

    @Test
    public void testOpenUrlWithInvalidPatchSetNumberOpenReview() throws Exception {
        String url = "http://review.mylyn.org/#/c/4698/5/foo/bar.java";
        GerritUrlHandler spy = this.setUpOpenUrlTests(url);
        GerritTaskEditorPage page = (GerritTaskEditorPage)Mockito.mock(GerritTaskEditorPage.class);
        IReview review = this.createMockReview();
        Mockito.when((Object)page.getReview()).thenReturn((Object)review);
        ((GerritUrlHandler)Mockito.doReturn((Object)page).when((Object)spy)).revealPatchSet((EditorHandle)ArgumentMatchers.any(EditorHandle.class), Integer.valueOf(ArgumentMatchers.anyInt()));
        this.openReviewTest(spy, url);
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getFileItem(review, 5, "foo/bar.java");
        Assert.assertNull((Object)spy.getFileItem(review, this.patchSetNumber, this.path));
    }

    @Test
    public void testOpenUrlWithInvalidPathOpenReview() throws Exception {
        String url = "http://review.mylyn.org/#/c/4698/1/foo/bar.jav";
        GerritUrlHandler spy = this.setUpOpenUrlTests(url);
        GerritTaskEditorPage page = (GerritTaskEditorPage)Mockito.mock(GerritTaskEditorPage.class);
        IReview review = this.createMockReview();
        Mockito.when((Object)page.getReview()).thenReturn((Object)review);
        ((GerritUrlHandler)Mockito.doReturn((Object)page).when((Object)spy)).revealPatchSet((EditorHandle)ArgumentMatchers.any(EditorHandle.class), Integer.valueOf(ArgumentMatchers.anyInt()));
        this.openReviewTest(spy, url);
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getFileItem(review, 1, "foo/bar.jav");
        Assert.assertNull((Object)spy.getFileItem(review, this.patchSetNumber, this.path));
    }

    private GerritUrlHandler setUpOpenUrlTests(String url) {
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        GerritUrlHandler spy = (GerritUrlHandler)Mockito.spy((Object)this.handler);
        TasksUi.getRepositoryManager().addRepository(this.repository);
        this.taskId = spy.getTaskId(this.repository, url);
        this.patchSetNumber = spy.getPatchSetNumber(this.repository, url, this.taskId);
        this.path = spy.getFilePath(this.repository, url, this.taskId, this.patchSetNumber);
        return spy;
    }

    private IReview createMockReview() {
        IReview mockReview = (IReview)Mockito.mock(IReview.class);
        IReviewItemSet mockSet = (IReviewItemSet)Mockito.mock(IReviewItemSet.class);
        IFileItem mockFile = (IFileItem)Mockito.mock(IFileItem.class);
        Mockito.when((Object)mockFile.getName()).thenReturn((Object)"foo/bar.java");
        Mockito.when((Object)mockSet.getId()).thenReturn((Object)"1");
        Mockito.when((Object)mockSet.getItems()).thenReturn(Arrays.asList(mockFile));
        Mockito.when((Object)mockReview.getSets()).thenReturn(Arrays.asList(mockSet));
        return mockReview;
    }

    private void openReviewTest(GerritUrlHandler spy, String url) {
        ((GerritUrlHandler)Mockito.doNothing().when((Object)spy)).openCompareEditor((IFileItem)ArgumentMatchers.any(IFileItem.class));
        spy.openUrl(this.page, url, 0);
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).revealPatchSet((EditorHandle)ArgumentMatchers.any(EditorHandle.class), Integer.valueOf(ArgumentMatchers.anyInt()));
        ((GerritUrlHandler)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).openCompareEditor((IFileItem)ArgumentMatchers.any(IFileItem.class));
    }

    private void assertPath(String expectedPath, String testUrl) {
        this.taskId = this.handler.getTaskId(this.repository, testUrl);
        this.patchSetNumber = this.handler.getPatchSetNumber(this.repository, testUrl, this.taskId);
        Assert.assertEquals((Object)expectedPath, (Object)this.handler.getFilePath(this.repository, testUrl, this.taskId, this.patchSetNumber));
    }
}

