/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCompareUi;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemCompareEditorInput;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class GerritCompareUiTest {
    private static final IEditorReference[] EMPTY_IEDITOR_REFERENCE_ARRAY = new IEditorReference[0];
    private static final String FILE_ITEM_ID = "Test file item ID";
    private static final String REVIEW_ITEM_SET_ID = "Test review item set ID";
    private static final String TEST_TASK_ID = "Test task ID";
    private static final String COMPARE_EDITOR_TITLE = "Compare Editor Title";
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private List<IEditorReference> editorReferences;
    private FileItemCompareEditorInput fileItemEditorInput;
    private ReviewItemSetCompareEditorInput reviewItemSetEditorInput;
    private IFileItem item;
    private IReviewItemSet items;

    @Before
    public void setUp() throws PartInitException {
        this.editorReferences = new ArrayList<IEditorReference>();
        this.editorReferences.add(this.getMockEditor("org.eclipse.other.Editor"));
        this.item = IReviewsFactory.INSTANCE.createFileItem();
        this.item.setId(FILE_ITEM_ID);
        this.item.setBase(this.getIFileVersion("Base Test Description"));
        this.item.setTarget(this.getIFileVersion("Target Test Description"));
        this.items = IReviewsFactory.INSTANCE.createReviewItemSet();
        this.items.setName(REVIEW_ITEM_SET_ID);
        GerritReviewBehavior behavior = new GerritReviewBehavior((ITask)Mockito.mock(ITask.class));
        CompareConfiguration configuration = new CompareConfiguration();
        this.fileItemEditorInput = new FileItemCompareEditorInput(configuration, this.item, (ReviewBehavior)behavior);
        this.reviewItemSetEditorInput = new ReviewItemSetCompareEditorInput(configuration, this.items, null, (ReviewBehavior)behavior);
    }

    private IFileVersion getIFileVersion(String description) {
        IFileVersion fileVersion = IReviewsFactory.INSTANCE.createFileVersion();
        fileVersion.setDescription(description);
        return fileVersion;
    }

    @Test
    public void testNoOpenCompareEditors() {
        CompareEditorInput newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.fileItemEditorInput, (Predicate)GerritCompareUi.getFileComparePredicate((IFileItem)this.item));
        Assert.assertEquals((Object)newInput, (Object)this.fileItemEditorInput);
        newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.reviewItemSetEditorInput, (Predicate)GerritCompareUi.getReviewItemSetComparePredicate((IReviewItemSet)this.items, (String)TEST_TASK_ID));
        Assert.assertEquals((Object)newInput, (Object)this.reviewItemSetEditorInput);
    }

    @Test
    public void testOpenNewFileCompareEditor() throws Exception {
        this.editorReferences.add(this.getMockFileCompareEditor());
        this.item.setId("New File Item ID");
        CompareEditorInput newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.fileItemEditorInput, (Predicate)GerritCompareUi.getFileComparePredicate((IFileItem)this.item));
        Assert.assertEquals((Object)newInput, (Object)this.fileItemEditorInput);
    }

    @Test
    public void testOpenNewReviewItemSetCompareEditor() throws Exception {
        this.editorReferences.add(this.getMockReviewItemSetCompareEditor());
        this.items.setName("New Review Item ID");
        CompareEditorInput newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.reviewItemSetEditorInput, (Predicate)GerritCompareUi.getReviewItemSetComparePredicate((IReviewItemSet)this.items, (String)TEST_TASK_ID));
        Assert.assertEquals((Object)newInput, (Object)this.reviewItemSetEditorInput);
        this.items.setName(REVIEW_ITEM_SET_ID);
        newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.reviewItemSetEditorInput, (Predicate)GerritCompareUi.getReviewItemSetComparePredicate((IReviewItemSet)this.items, (String)"New Test Task Id"));
        Assert.assertEquals((Object)newInput, (Object)this.reviewItemSetEditorInput);
    }

    @Test
    public void testOpenExistingFileCompareEditor() throws Exception {
        this.editorReferences.add(this.getMockFileCompareEditor());
        CompareEditorInput newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.fileItemEditorInput, (Predicate)GerritCompareUi.getFileComparePredicate((IFileItem)this.item));
        Assert.assertTrue((newInput != this.fileItemEditorInput ? 1 : 0) != 0);
        Assert.assertEquals((Object)COMPARE_EDITOR_TITLE, (Object)newInput.getTitle());
    }

    @Test
    public void testOpenExistingReviewItemSetCompareEditor() throws Exception {
        this.editorReferences.add(this.getMockReviewItemSetCompareEditor());
        CompareEditorInput newInput = GerritCompareUi.getComparisonEditorInput((IEditorReference[])this.editorReferences.toArray(EMPTY_IEDITOR_REFERENCE_ARRAY), (CompareEditorInput)this.reviewItemSetEditorInput, (Predicate)GerritCompareUi.getReviewItemSetComparePredicate((IReviewItemSet)this.items, (String)TEST_TASK_ID));
        Assert.assertTrue((newInput != this.reviewItemSetEditorInput ? 1 : 0) != 0);
        Assert.assertEquals((Object)COMPARE_EDITOR_TITLE, (Object)newInput.getTitle());
    }

    private IEditorReference getMockEditor(String id) {
        IEditorReference ref = (IEditorReference)Mockito.mock(IEditorReference.class);
        Mockito.when((Object)ref.getId()).thenReturn((Object)id);
        return ref;
    }

    private IEditorReference getMockFileCompareEditor() throws PartInitException {
        FileItemCompareEditorInput input = (FileItemCompareEditorInput)Mockito.mock(FileItemCompareEditorInput.class);
        Mockito.when((Object)input.getFileItemId()).thenReturn((Object)FILE_ITEM_ID);
        Mockito.when((Object)input.getTitle()).thenReturn((Object)COMPARE_EDITOR_TITLE);
        IEditorReference ref = this.getMockEditor(COMPARE_EDITOR);
        Mockito.when((Object)ref.getEditorInput()).thenReturn((Object)input);
        return ref;
    }

    private IEditorReference getMockReviewItemSetCompareEditor() throws PartInitException {
        ReviewItemSetCompareEditorInput input = (ReviewItemSetCompareEditorInput)Mockito.mock(ReviewItemSetCompareEditorInput.class);
        Mockito.when((Object)input.getName()).thenReturn((Object)REVIEW_ITEM_SET_ID);
        Mockito.when((Object)input.getTitle()).thenReturn((Object)COMPARE_EDITOR_TITLE);
        Mockito.when((Object)input.getItemTaskId()).thenReturn((Object)TEST_TASK_ID);
        IEditorReference ref = this.getMockEditor(COMPARE_EDITOR);
        Mockito.when((Object)ref.getEditorInput()).thenReturn((Object)input);
        return ref;
    }
}

