/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.mylyn.commons.workbench.browser.UrlHyperlink;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.CommentLink;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCommentLinkDetector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.junit.Assert;
import org.junit.Test;

public class GerritCommentLinkDetectorTest {
    TaskRepository repository = new TaskRepository("org.eclipse.mylyn.gerrit", "http://review.mylyn.org");
    List<CommentLink> commentLinks = new ArrayList<CommentLink>();
    private static CommentLink COMMENT_LINK_TASK = new CommentLink("([Tt]ask:\\s+)(\\d+)", "$1<a href=\"http://tracker.mylyn.org/$2\">$2</a>");
    private static CommentLink COMMENT_LINK_TASK_INVALID = new CommentLink("([Tt]ask:\\s+)(\\d+)", "http://tracker.mylyn.org/$2");
    private static CommentLink COMMENT_LINK_CHANGE = new CommentLink("(I[0-9a-f]{8,40})", "<a href=\"#q,$1,n,z\">$&</a>");
    private static CommentLink COMMENT_LINK_BUG = new CommentLink("(bug\\s+)(\\d+)", "<a href=\"http://bugs.mylyn.org/show_bug.cgi?id=$2\">$&</a>");

    @Test
    public void testTaskPattern() {
        this.commentLinks.add(COMMENT_LINK_TASK);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        UrlHyperlink expected = new UrlHyperlink((IRegion)new Region(0, 9), "http://tracker.mylyn.org/123");
        Assert.assertEquals((Object)String.valueOf(Collections.singletonList(expected)), (Object)String.valueOf(detector.findHyperlinks("Task: 123", 0, 0)));
    }

    @Test
    public void testLinkChangeId() {
        this.commentLinks.add(COMMENT_LINK_CHANGE);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        UrlHyperlink expected = new UrlHyperlink((IRegion)new Region(0, 41), "http://review.mylyn.org/#q,If1d90fa42e1e98f03a68fb59c2b5bedc3d371f0f,n,z");
        Assert.assertEquals((Object)String.valueOf(Collections.singletonList(expected)), (Object)String.valueOf(detector.findHyperlinks("If1d90fa42e1e98f03a68fb59c2b5bedc3d371f0f", 0, 0)));
    }

    @Test
    public void testTaskPatternInvalid() {
        this.commentLinks.add(COMMENT_LINK_TASK_INVALID);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        Assert.assertEquals((Object)"null", (Object)String.valueOf(detector.findHyperlinks("Task: 123", 0, 0)));
    }

    @Test
    public void testTaskPatternTwice() {
        this.commentLinks.add(COMMENT_LINK_TASK);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        UrlHyperlink expected1 = new UrlHyperlink((IRegion)new Region(4, 9), "http://tracker.mylyn.org/123");
        UrlHyperlink expected2 = new UrlHyperlink((IRegion)new Region(18, 7), "http://tracker.mylyn.org/4");
        Assert.assertEquals((Object)String.valueOf(Arrays.asList(expected1, expected2)), (Object)String.valueOf(detector.findHyperlinks("abc Task: 123 and Task: 4", -1, 0)));
    }

    @Test
    public void testTaskPatternNoMatch() {
        this.commentLinks.add(COMMENT_LINK_TASK);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        Assert.assertEquals((Object)"null", (Object)String.valueOf(detector.findHyperlinks("Task 123", 0, 0)));
    }

    @Test
    public void testTaskPatternNoMatchBug() {
        this.commentLinks.add(COMMENT_LINK_TASK);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        Assert.assertEquals((Object)"null", (Object)String.valueOf(detector.findHyperlinks("Bug 123", 0, 0)));
    }

    @Test
    public void testTaskBugPatternTwice() {
        this.commentLinks.add(COMMENT_LINK_TASK);
        this.commentLinks.add(COMMENT_LINK_BUG);
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, this.commentLinks);
        UrlHyperlink expected1 = new UrlHyperlink((IRegion)new Region(4, 9), "http://tracker.mylyn.org/123");
        UrlHyperlink expected2 = new UrlHyperlink((IRegion)new Region(18, 5), "http://bugs.mylyn.org/show_bug.cgi?id=4");
        Assert.assertEquals((Object)String.valueOf(Arrays.asList(expected1, expected2)), (Object)String.valueOf(detector.findHyperlinks("abc Task: 123 and bug 4", -1, 0)));
    }

    @Test
    public void testNoPattern() {
        GerritCommentLinkDetector detector = new GerritCommentLinkDetector(this.repository, null);
        Assert.assertEquals((Object)"null", (Object)String.valueOf(detector.findHyperlinks("Bug 123", 0, 0)));
    }
}

